/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ByteUtilities;
import com.cedarsoftware.util.ExceptionUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtilities {
    private static final long DEFAULT_MAX_FILE_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_BUFFER_SIZE = 0x100000;
    private static final int DEFAULT_MIN_PBKDF2_ITERATIONS = 10000;
    private static final int DEFAULT_MAX_PBKDF2_ITERATIONS = 1000000;
    private static final int DEFAULT_MIN_SALT_SIZE = 8;
    private static final int DEFAULT_MAX_SALT_SIZE = 64;
    private static final int DEFAULT_MIN_IV_SIZE = 8;
    private static final int DEFAULT_MAX_IV_SIZE = 32;
    private static final int STANDARD_PBKDF2_ITERATIONS = 65536;
    private static final int STANDARD_SALT_SIZE = 16;
    private static final int STANDARD_IV_SIZE = 12;
    private static final int STANDARD_BUFFER_SIZE = 65536;

    private static void initializeSystemPropertyDefaults() {
        if (System.getProperty("encryptionutilities.max.file.size") == null) {
            System.setProperty("encryptionutilities.max.file.size", String.valueOf(Integer.MAX_VALUE));
        }
        if (System.getProperty("encryptionutilities.max.buffer.size") == null) {
            System.setProperty("encryptionutilities.max.buffer.size", String.valueOf(0x100000));
        }
        if (System.getProperty("encryptionutilities.min.pbkdf2.iterations") == null) {
            System.setProperty("encryptionutilities.min.pbkdf2.iterations", String.valueOf(10000));
        }
        if (System.getProperty("encryptionutilities.max.pbkdf2.iterations") == null) {
            System.setProperty("encryptionutilities.max.pbkdf2.iterations", String.valueOf(1000000));
        }
        if (System.getProperty("encryptionutilities.min.salt.size") == null) {
            System.setProperty("encryptionutilities.min.salt.size", String.valueOf(8));
        }
        if (System.getProperty("encryptionutilities.max.salt.size") == null) {
            System.setProperty("encryptionutilities.max.salt.size", String.valueOf(64));
        }
        if (System.getProperty("encryptionutilities.min.iv.size") == null) {
            System.setProperty("encryptionutilities.min.iv.size", String.valueOf(8));
        }
        if (System.getProperty("encryptionutilities.max.iv.size") == null) {
            System.setProperty("encryptionutilities.max.iv.size", String.valueOf(32));
        }
    }

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("encryptionutilities.security.enabled", "false"));
    }

    private static boolean isFileSizeValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("encryptionutilities.file.size.validation.enabled", "false"));
    }

    private static boolean isBufferSizeValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("encryptionutilities.buffer.size.validation.enabled", "false"));
    }

    private static boolean isCryptoParametersValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("encryptionutilities.crypto.parameters.validation.enabled", "false"));
    }

    private static long getMaxFileSize() {
        String maxFileSizeProp = System.getProperty("encryptionutilities.max.file.size");
        if (maxFileSizeProp != null) {
            try {
                return Math.max(1L, Long.parseLong(maxFileSizeProp));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return EncryptionUtilities.isSecurityEnabled() ? Integer.MAX_VALUE : Long.MAX_VALUE;
    }

    private static int getMaxBufferSize() {
        String maxBufferSizeProp = System.getProperty("encryptionutilities.max.buffer.size");
        if (maxBufferSizeProp != null) {
            try {
                return Math.max(1024, Integer.parseInt(maxBufferSizeProp));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return EncryptionUtilities.isSecurityEnabled() ? 0x100000 : Integer.MAX_VALUE;
    }

    private static int getValidatedPBKDF2Iterations(int requestedIterations) {
        if (!EncryptionUtilities.isSecurityEnabled() || !EncryptionUtilities.isCryptoParametersValidationEnabled()) {
            return requestedIterations;
        }
        int minIterations = EncryptionUtilities.getMinPBKDF2Iterations();
        int maxIterations = EncryptionUtilities.getMaxPBKDF2Iterations();
        if (requestedIterations < minIterations) {
            throw new SecurityException("PBKDF2 iteration count too low (min " + minIterations + "): " + requestedIterations);
        }
        if (requestedIterations > maxIterations) {
            throw new SecurityException("PBKDF2 iteration count too high (max " + maxIterations + "): " + requestedIterations);
        }
        return requestedIterations;
    }

    private static int getMinPBKDF2Iterations() {
        String minIterationsProp = System.getProperty("encryptionutilities.min.pbkdf2.iterations");
        if (minIterationsProp != null) {
            try {
                return Math.max(1000, Integer.parseInt(minIterationsProp));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 10000;
    }

    private static int getMaxPBKDF2Iterations() {
        String maxIterationsProp = System.getProperty("encryptionutilities.max.pbkdf2.iterations");
        if (maxIterationsProp != null) {
            try {
                return Integer.parseInt(maxIterationsProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1000000;
    }

    private static int getValidatedBufferSize(int requestedSize) {
        if (!EncryptionUtilities.isSecurityEnabled() || !EncryptionUtilities.isBufferSizeValidationEnabled()) {
            return requestedSize;
        }
        int maxBufferSize = EncryptionUtilities.getMaxBufferSize();
        if (requestedSize > maxBufferSize) {
            throw new SecurityException("Buffer size too large (max " + maxBufferSize + "): " + requestedSize);
        }
        if (requestedSize < 1024) {
            throw new SecurityException("Buffer size too small (min 1024): " + requestedSize);
        }
        return requestedSize;
    }

    private static void validateFileSize(File file) {
        if (!EncryptionUtilities.isSecurityEnabled() || !EncryptionUtilities.isFileSizeValidationEnabled()) {
            return;
        }
        try {
            long fileSize = file.length();
            long maxFileSize = EncryptionUtilities.getMaxFileSize();
            if (fileSize > maxFileSize) {
                throw new SecurityException("File size too large (max " + maxFileSize + " bytes): " + fileSize);
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void validateCryptoParameterSize(int size, String paramName, int minSize, int maxSize) {
        if (!EncryptionUtilities.isSecurityEnabled() || !EncryptionUtilities.isCryptoParametersValidationEnabled()) {
            return;
        }
        if (size < minSize) {
            throw new SecurityException(paramName + " size too small (min " + minSize + "): " + size);
        }
        if (size > maxSize) {
            throw new SecurityException(paramName + " size too large (max " + maxSize + "): " + size);
        }
    }

    private EncryptionUtilities() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastMD5(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getMD5Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getMD5Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String calculateStreamHash(InputStream in, MessageDigest digest) {
        int BUFFER_SIZE = EncryptionUtilities.getValidatedBufferSize(65536);
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        return ByteUtilities.encode(digest.digest());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA1(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA1Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA1Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA256(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA256Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA256Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA384(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA384Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA384Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA512(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA512Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA512Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA3_256(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA3_256Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA3_256Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA3_512(File file) {
        EncryptionUtilities.validateFileSize(file);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            if (in instanceof FileInputStream) {
                String string2 = EncryptionUtilities.calculateFileHash(((FileInputStream)in).getChannel(), EncryptionUtilities.getSHA3_512Digest());
                return string2;
            }
            String string = EncryptionUtilities.calculateStreamHash(in, EncryptionUtilities.getSHA3_512Digest());
            return string;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String calculateFileHash(FileChannel channel, MessageDigest digest) {
        int BUFFER_SIZE = EncryptionUtilities.getValidatedBufferSize(65536);
        ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);
        try {
            while (channel.read(buffer) != -1) {
                buffer.flip();
                digest.update(buffer);
                buffer.clear();
            }
            return ByteUtilities.encode(digest.digest());
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static String calculateMD5Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getMD5Digest(), bytes);
    }

    public static MessageDigest getDigest(String digest) {
        try {
            return MessageDigest.getInstance(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("The requested MessageDigest (%s) does not exist", digest), e);
        }
    }

    public static MessageDigest getMD5Digest() {
        return EncryptionUtilities.getDigest("MD5");
    }

    public static String calculateSHA1Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA1Digest(), bytes);
    }

    public static MessageDigest getSHA1Digest() {
        return EncryptionUtilities.getDigest("SHA-1");
    }

    public static String calculateSHA256Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA256Digest(), bytes);
    }

    public static MessageDigest getSHA256Digest() {
        return EncryptionUtilities.getDigest("SHA-256");
    }

    public static String calculateSHA384Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA384Digest(), bytes);
    }

    public static MessageDigest getSHA384Digest() {
        return EncryptionUtilities.getDigest("SHA-384");
    }

    public static String calculateSHA512Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA512Digest(), bytes);
    }

    public static MessageDigest getSHA512Digest() {
        return EncryptionUtilities.getDigest("SHA-512");
    }

    public static String calculateSHA3_256Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA3_256Digest(), bytes);
    }

    public static MessageDigest getSHA3_256Digest() {
        return EncryptionUtilities.getDigest("SHA3-256");
    }

    public static String calculateSHA3_512Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA3_512Digest(), bytes);
    }

    public static MessageDigest getSHA3_512Digest() {
        return EncryptionUtilities.getDigest("SHA3-512");
    }

    public static byte[] deriveKey(String password, byte[] salt, int bitsNeeded) {
        int iterations = EncryptionUtilities.getValidatedPBKDF2Iterations(65536);
        EncryptionUtilities.validateCryptoParameterSize(salt.length, "Salt", Integer.parseInt(System.getProperty("encryptionutilities.min.salt.size", String.valueOf(8))), Integer.parseInt(System.getProperty("encryptionutilities.max.salt.size", String.valueOf(64))));
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, bitsNeeded);
            return factory.generateSecret(spec).getEncoded();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to derive key", e);
        }
    }

    public static byte[] createCipherBytes(String key, int bitsNeeded) {
        String word = EncryptionUtilities.calculateMD5Hash(key.getBytes(StandardCharsets.UTF_8));
        return word.substring(0, bitsNeeded / 8).getBytes(StandardCharsets.UTF_8);
    }

    @Deprecated
    public static Cipher createAesEncryptionCipher(String key) {
        return EncryptionUtilities.createAesCipher(key, 1);
    }

    @Deprecated
    public static Cipher createAesDecryptionCipher(String key) {
        return EncryptionUtilities.createAesCipher(key, 2);
    }

    @Deprecated
    public static Cipher createAesCipher(String key, int mode) {
        SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.createCipherBytes(key, 128), "AES");
        return EncryptionUtilities.createAesCipher(sKey, mode);
    }

    @Deprecated
    public static Cipher createAesCipher(Key key, int mode) {
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(key.getEncoded());
        byte[] iv = d.digest();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        try {
            cipher.init(mode, key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        return cipher;
    }

    public static String encrypt(String key, String content) {
        if (key == null || content == null) {
            throw new IllegalArgumentException("key and content cannot be null");
        }
        try {
            SecureRandom random = new SecureRandom();
            int saltSize = 16;
            int ivSize = 12;
            EncryptionUtilities.validateCryptoParameterSize(saltSize, "Salt", Integer.parseInt(System.getProperty("encryptionutilities.min.salt.size", String.valueOf(8))), Integer.parseInt(System.getProperty("encryptionutilities.max.salt.size", String.valueOf(64))));
            EncryptionUtilities.validateCryptoParameterSize(ivSize, "IV", Integer.parseInt(System.getProperty("encryptionutilities.min.iv.size", String.valueOf(8))), Integer.parseInt(System.getProperty("encryptionutilities.max.iv.size", String.valueOf(32))));
            byte[] salt = new byte[saltSize];
            random.nextBytes(salt);
            byte[] iv = new byte[ivSize];
            random.nextBytes(iv);
            SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, new GCMParameterSpec(128, iv));
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] out = new byte[1 + salt.length + iv.length + encrypted.length];
            out[0] = 1;
            System.arraycopy(salt, 0, out, 1, salt.length);
            System.arraycopy(iv, 0, out, 1 + salt.length, iv.length);
            System.arraycopy(encrypted, 0, out, 1 + salt.length + iv.length, encrypted.length);
            return ByteUtilities.encode(out);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String encryptBytes(String key, byte[] content) {
        if (key == null || content == null) {
            throw new IllegalArgumentException("key and content cannot be null");
        }
        try {
            SecureRandom random = new SecureRandom();
            int saltSize = 16;
            int ivSize = 12;
            EncryptionUtilities.validateCryptoParameterSize(saltSize, "Salt", Integer.parseInt(System.getProperty("encryptionutilities.min.salt.size", String.valueOf(8))), Integer.parseInt(System.getProperty("encryptionutilities.max.salt.size", String.valueOf(64))));
            EncryptionUtilities.validateCryptoParameterSize(ivSize, "IV", Integer.parseInt(System.getProperty("encryptionutilities.min.iv.size", String.valueOf(8))), Integer.parseInt(System.getProperty("encryptionutilities.max.iv.size", String.valueOf(32))));
            byte[] salt = new byte[saltSize];
            random.nextBytes(salt);
            byte[] iv = new byte[ivSize];
            random.nextBytes(iv);
            SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)sKey, new GCMParameterSpec(128, iv));
            byte[] encrypted = cipher.doFinal(content);
            byte[] out = new byte[1 + salt.length + iv.length + encrypted.length];
            out[0] = 1;
            System.arraycopy(salt, 0, out, 1, salt.length);
            System.arraycopy(iv, 0, out, 1 + salt.length, iv.length);
            System.arraycopy(encrypted, 0, out, 1 + salt.length + iv.length, encrypted.length);
            return ByteUtilities.encode(out);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String decrypt(String key, String hexStr) {
        if (key == null || hexStr == null) {
            throw new IllegalArgumentException("key and hexStr cannot be null");
        }
        byte[] data = ByteUtilities.decode(hexStr);
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid hexadecimal input");
        }
        try {
            if (data[0] == 1 && data.length > 29) {
                byte[] salt = Arrays.copyOfRange(data, 1, 17);
                byte[] iv = Arrays.copyOfRange(data, 17, 29);
                byte[] cipherText = Arrays.copyOfRange(data, 29, data.length);
                SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)sKey, new GCMParameterSpec(128, iv));
                return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8);
            }
            return new String(EncryptionUtilities.createAesDecryptionCipher(key).doFinal(data), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static byte[] decryptBytes(String key, String hexStr) {
        if (key == null || hexStr == null) {
            throw new IllegalArgumentException("key and hexStr cannot be null");
        }
        byte[] data = ByteUtilities.decode(hexStr);
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid hexadecimal input");
        }
        try {
            if (data[0] == 1 && data.length > 29) {
                byte[] salt = Arrays.copyOfRange(data, 1, 17);
                byte[] iv = Arrays.copyOfRange(data, 17, 29);
                byte[] cipherText = Arrays.copyOfRange(data, 29, data.length);
                SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.deriveKey(key, salt, 128), "AES");
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)sKey, new GCMParameterSpec(128, iv));
                return cipher.doFinal(cipherText);
            }
            return EncryptionUtilities.createAesDecryptionCipher(key).doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static String calculateHash(MessageDigest d, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }

    static {
        EncryptionUtilities.initializeSystemPropertyDefaults();
    }
}

