/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class CalendarConversions {
    private CalendarConversions() {
    }

    static Long toLong(Object from, Converter converter) {
        return ((Calendar)from).getTime().getTime();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(((Calendar)from).getTime().getTime());
    }

    static double toDouble(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        long epochMillis = calendar.getTime().getTime();
        return (double)epochMillis / 1000.0;
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Calendar cal = (Calendar)from;
        long epochMillis = cal.getTime().getTime();
        return new BigDecimal(epochMillis).divide(BigDecimal.valueOf(1000L));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return BigInteger.valueOf(((Calendar)from).getTime().getTime());
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return ((Calendar)from).getTime();
    }

    static Date toSqlDate(Object from, Converter converter) {
        return Date.valueOf(((Calendar)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(((Calendar)from).getTimeInMillis());
    }

    static Instant toInstant(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return calendar.toInstant();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return calendar.toInstant().atZone(calendar.getTimeZone().toZoneId());
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Calendar cal = (Calendar)from;
        OffsetDateTime offsetDateTime = cal.toInstant().atOffset(ZoneOffset.ofTotalSeconds(cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 1000));
        return offsetDateTime;
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return CalendarConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static Calendar clone(Object from, Converter converter) {
        Calendar calendar = (Calendar)from;
        return (Calendar)calendar.clone();
    }

    static Calendar create(long epochMilli, Converter converter) {
        Calendar cal = Calendar.getInstance(converter.getOptions().getTimeZone());
        cal.clear();
        cal.setTimeInMillis(epochMilli);
        return cal;
    }

    static Year toYear(Object from, Converter converter) {
        return Year.from(((Calendar)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return YearMonth.from(((Calendar)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MonthDay.from(((Calendar)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static String toString(Object from, Converter converter) {
        String fullZone;
        ZonedDateTime zdt = CalendarConversions.toZonedDateTime(from, converter);
        String zoneId = zdt.getZone().getId();
        if (!zoneId.contains("/") && (fullZone = DateUtilities.ABBREVIATION_TO_TIMEZONE.get(zoneId)) != null) {
            zdt = zdt.withZoneSameInstant(ZoneId.of(fullZone));
        }
        if (zdt.getZone() instanceof ZoneOffset) {
            DateTimeFormatter offsetFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendPattern("XXX").toFormatter();
            return offsetFormatter.format(zdt);
        }
        DateTimeFormatter zoneFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendPattern("XXX'['VV']'").toFormatter();
        return zoneFormatter.format(zdt);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("calendar", CalendarConversions.toString(from, converter));
        return target;
    }
}

