/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

final class UriConversions {
    private UriConversions() {
    }

    static Map toMap(Object from, Converter converter) {
        URI uri = (URI)from;
        LinkedHashMap<String, String> target = new LinkedHashMap<String, String>();
        target.put("URI", uri.toString());
        return target;
    }

    static URL toURL(Object from, Converter converter) {
        URI uri = (URI)from;
        try {
            return uri.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URI to URL, input URI: " + uri, e);
        }
    }

    static File toFile(Object from, Converter converter) {
        URI uri = (URI)from;
        try {
            return new File(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URI to File, input URI: " + uri, e);
        }
    }

    static Path toPath(Object from, Converter converter) {
        URI uri = (URI)from;
        try {
            return Paths.get(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert URI to Path, input URI: " + uri, e);
        }
    }
}

