// Code generated by gobind. DO NOT EDIT.

// Java class com.celzero.firestack.backend.IpTree is a proxy for talking to a Go program.
//
//   autogenerated by gobind -lang=java -javapkg=com.celzero.firestack github.com/celzero/firestack/intra/backend
package com.celzero.firestack.backend;

import go.Seq;

/**
 * A IpTree is a thread-safe trie that supports insertion, deletion, and route matching IP CIDRs.
 */
public interface IpTree {
	/**
	 * Adds value v to the cidr route.
	 */
	public void add(Gostr cidr, Gostr v) throws Exception;
	/**
	 * Clears the trie.
	 */
	public void clear();
	/**
	 * Deletes cidr route. Returns true if cidr was found.
	 */
	public boolean del(Gostr cidr);
	/**
	 * Deletes all routes matching cidr. Returns the number of routes deleted.
	 */
	public int delAll(Gostr cidr);
	/**
	 * Removes value v, if found.
	 */
	public boolean esc(Gostr cidr, Gostr v);
	/**
	 * Removes values like v (&#34;*v*&#34;) for cidr.
	 */
	public int escLike(Gostr cidr, Gostr likev);
	/**
	 * Gets the value of cidr or &#34;&#34; if cidr is not found.
	 */
	public Gostr get(Gostr cidr) throws Exception;
	/**
	 * Returns the longest route for cidr as &#34;r1@csv(v)|r2@csv(v2)&#34; or &#34;&#34;.
	 */
	public Gostr getAll(Gostr cidr) throws Exception;
	/**
	 * Returns the route@csv(value) of any route matching cidr or &#34;&#34;.
	 */
	public Gostr getAny(Gostr cidr) throws Exception;
	/**
	 * Returns csv of all values like v for cidr.
	 */
	public Gostr getLike(Gostr cidr, Gostr likev);
	/**
	 * Returns true if the cidr route is found.
	 */
	public boolean has(Gostr cidr) throws Exception;
	/**
	 * Returns true if any route matches cidr.
	 */
	public boolean hasAny(Gostr cidr) throws Exception;
	/**
	 * Returns the number of routes.
	 */
	public long len();
	/**
	 * Returns csv of all routes matching cidr or &#34;&#34;.
	 */
	public Gostr routes(Gostr cidr);
	/**
	 * Returns csv of all routes with any value like v matching cidr.
	 */
	public Gostr routesLike(Gostr cidr, Gostr likev);
	/**
	 * Sets cidr route to v, overwriting any previous value.
	 */
	public void set(Gostr cidr, Gostr v) throws Exception;
	/**
	 * Returns csv of values of all routes matching cidr or &#34;&#34;.
	 */
	public Gostr values(Gostr cidr);
	/**
	 * Returns csv of all routes with values like v for cidr.
	 */
	public Gostr valuesLike(Gostr cidr, Gostr likev);
	
}

