/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.connections;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.connections.connectiontocourier.AsyncConnectionToCourierClient;
import com.chrt.api.resources.connections.connectiontoforwarder.AsyncConnectionToForwarderClient;
import com.chrt.api.resources.connections.connectiontoshipper.AsyncConnectionToShipperClient;
import com.chrt.api.types.CourierConnectionRes;
import com.chrt.api.types.ForwarderConnectionRes;
import com.chrt.api.types.ShipperConnectionRes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncConnectionsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawConnectionsClient rawClient;

    protected final Supplier<AsyncConnectionToCourierClient> connectionToCourierClient;

    protected final Supplier<AsyncConnectionToShipperClient> connectionToShipperClient;

    protected final Supplier<AsyncConnectionToForwarderClient> connectionToForwarderClient;

    public AsyncConnectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConnectionsClient(clientOptions);
        this.connectionToCourierClient = Suppliers.memoize(() -> new AsyncConnectionToCourierClient(clientOptions));
        this.connectionToShipperClient = Suppliers.memoize(() -> new AsyncConnectionToShipperClient(clientOptions));
        this.connectionToForwarderClient = Suppliers.memoize(() -> new AsyncConnectionToForwarderClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawConnectionsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists shipper organizations based on the authenticated organization type. Couriers see connected shippers, forwarders see connected shippers. | () -&gt; (list[ShipperConnectionRes])
     */
    public CompletableFuture<List<ShipperConnectionRes>> listShippersV1() {
        return this.rawClient.listShippersV1().thenApply(response -> response.body());
    }

    /**
     * Lists shipper organizations based on the authenticated organization type. Couriers see connected shippers, forwarders see connected shippers. | () -&gt; (list[ShipperConnectionRes])
     */
    public CompletableFuture<List<ShipperConnectionRes>> listShippersV1(RequestOptions requestOptions) {
        return this.rawClient.listShippersV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists courier organizations based on the authenticated organization type. Shippers see connected couriers, forwarders see connected couriers. | () -&gt; (list[CourierConnectionRes])
     */
    public CompletableFuture<List<CourierConnectionRes>> listCouriersV1() {
        return this.rawClient.listCouriersV1().thenApply(response -> response.body());
    }

    /**
     * Lists courier organizations based on the authenticated organization type. Shippers see connected couriers, forwarders see connected couriers. | () -&gt; (list[CourierConnectionRes])
     */
    public CompletableFuture<List<CourierConnectionRes>> listCouriersV1(RequestOptions requestOptions) {
        return this.rawClient.listCouriersV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists forwarder organizations based on the authenticated organization type. Shippers see connected forwarders, couriers see connected forwarders. | () -&gt; (list[ForwarderConnectionRes])
     */
    public CompletableFuture<List<ForwarderConnectionRes>> listForwardersV1() {
        return this.rawClient.listForwardersV1().thenApply(response -> response.body());
    }

    /**
     * Lists forwarder organizations based on the authenticated organization type. Shippers see connected forwarders, couriers see connected forwarders. | () -&gt; (list[ForwarderConnectionRes])
     */
    public CompletableFuture<List<ForwarderConnectionRes>> listForwardersV1(RequestOptions requestOptions) {
        return this.rawClient.listForwardersV1(requestOptions).thenApply(response -> response.body());
    }

    public AsyncConnectionToCourierClient connectionToCourier() {
        return this.connectionToCourierClient.get();
    }

    public AsyncConnectionToShipperClient connectionToShipper() {
        return this.connectionToShipperClient.get();
    }

    public AsyncConnectionToForwarderClient connectionToForwarder() {
        return this.connectionToForwarderClient.get();
    }
}
