/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverlineitemgroups.addlineitems.requests;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemClientCreate1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CourierPayDriverLineItemGroupAddLineItemsReq.Builder.class)
public final class CourierPayDriverLineItemGroupAddLineItemsReq {
    private final List<LineItemClientCreate1> lineItems;

    private final Map<String, Object> additionalProperties;

    private CourierPayDriverLineItemGroupAddLineItemsReq(
            List<LineItemClientCreate1> lineItems, Map<String, Object> additionalProperties) {
        this.lineItems = lineItems;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Line items to add to the group
     */
    @JsonProperty("line_items")
    public List<LineItemClientCreate1> getLineItems() {
        return lineItems;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CourierPayDriverLineItemGroupAddLineItemsReq
                && equalTo((CourierPayDriverLineItemGroupAddLineItemsReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CourierPayDriverLineItemGroupAddLineItemsReq other) {
        return lineItems.equals(other.lineItems);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.lineItems);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<LineItemClientCreate1> lineItems = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CourierPayDriverLineItemGroupAddLineItemsReq other) {
            lineItems(other.getLineItems());
            return this;
        }

        /**
         * <p>Line items to add to the group</p>
         */
        @JsonSetter(value = "line_items", nulls = Nulls.SKIP)
        public Builder lineItems(List<LineItemClientCreate1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        public Builder addLineItems(LineItemClientCreate1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        public Builder addAllLineItems(List<LineItemClientCreate1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        public CourierPayDriverLineItemGroupAddLineItemsReq build() {
            return new CourierPayDriverLineItemGroupAddLineItemsReq(lineItems, additionalProperties);
        }
    }
}
