/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverpayouts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CourierPayDriverStatement1;
import com.chrt.api.types.CourierPayDriverStatementClientCreate1;
import com.chrt.api.types.CourierPayDriverStatementClientUpdate1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierPayDriverPayoutsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCourierPayDriverPayoutsClient rawClient;

    public AsyncCourierPayDriverPayoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierPayDriverPayoutsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCourierPayDriverPayoutsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a specific courier driver payout by ID for the authenticated organization.
     */
    public CompletableFuture<CourierPayDriverStatement1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a specific courier driver payout by ID for the authenticated organization.
     */
    public CompletableFuture<CourierPayDriverStatement1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all payouts for a specific driver within the authenticated organization.
     */
    public CompletableFuture<List<CourierPayDriverStatement1>> listByDriverIdV1(String driverId) {
        return this.rawClient.listByDriverIdV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Lists all payouts for a specific driver within the authenticated organization.
     */
    public CompletableFuture<List<CourierPayDriverStatement1>> listByDriverIdV1(
            String driverId, RequestOptions requestOptions) {
        return this.rawClient.listByDriverIdV1(driverId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver payout from selected line item groups and calculates the total amount.
     */
    public CompletableFuture<String> createV1(CourierPayDriverStatementClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver payout from selected line item groups and calculates the total amount.
     */
    public CompletableFuture<String> createV1(
            CourierPayDriverStatementClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(String id) {
        return this.rawClient.updateStatusV1(id).thenApply(response -> response.body());
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(
            String id, CourierPayDriverStatementClientUpdate1 request) {
        return this.rawClient.updateStatusV1(id, request).thenApply(response -> response.body());
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CompletableFuture<CourierPayDriverStatement1> updateStatusV1(
            String id, CourierPayDriverStatementClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateStatusV1(id, request, requestOptions).thenApply(response -> response.body());
    }
}
