/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverpayouts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.CourierPayDriverStatement1;
import com.chrt.api.types.CourierPayDriverStatementClientCreate1;
import com.chrt.api.types.CourierPayDriverStatementClientUpdate1;
import java.util.List;

public class CourierPayDriverPayoutsClient {
    protected final ClientOptions clientOptions;

    private final RawCourierPayDriverPayoutsClient rawClient;

    public CourierPayDriverPayoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCourierPayDriverPayoutsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCourierPayDriverPayoutsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a specific courier driver payout by ID for the authenticated organization.
     */
    public CourierPayDriverStatement1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    /**
     * Retrieves a specific courier driver payout by ID for the authenticated organization.
     */
    public CourierPayDriverStatement1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    /**
     * Lists all payouts for a specific driver within the authenticated organization.
     */
    public List<CourierPayDriverStatement1> listByDriverIdV1(String driverId) {
        return this.rawClient.listByDriverIdV1(driverId).body();
    }

    /**
     * Lists all payouts for a specific driver within the authenticated organization.
     */
    public List<CourierPayDriverStatement1> listByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.listByDriverIdV1(driverId, requestOptions).body();
    }

    /**
     * Creates a new driver payout from selected line item groups and calculates the total amount.
     */
    public String createV1(CourierPayDriverStatementClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a new driver payout from selected line item groups and calculates the total amount.
     */
    public String createV1(CourierPayDriverStatementClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CourierPayDriverStatement1 updateStatusV1(String id) {
        return this.rawClient.updateStatusV1(id).body();
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CourierPayDriverStatement1 updateStatusV1(String id, CourierPayDriverStatementClientUpdate1 request) {
        return this.rawClient.updateStatusV1(id, request).body();
    }

    /**
     * Updates the status of a courier driver payout with validation of allowed state transitions.
     */
    public CourierPayDriverStatement1 updateStatusV1(
            String id, CourierPayDriverStatementClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateStatusV1(id, request, requestOptions).body();
    }
}
