/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.courierpaydriverratesheets;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.courierpaydriverratesheets.requests.CourierPayDriverRateSheetClientCreate1;
import com.chrt.api.resources.courierpaydriverratesheets.requests.CourierPayDriverRateSheetClientUpdate1;
import com.chrt.api.types.CourierPayDriverRateSheet1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierPayDriverRateSheetsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCourierPayDriverRateSheetsClient rawClient;

    public AsyncCourierPayDriverRateSheetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierPayDriverRateSheetsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCourierPayDriverRateSheetsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all driver rate sheets for the authenticated courier organization.
     */
    public CompletableFuture<List<CourierPayDriverRateSheet1>> listByCourierOrgIdV1() {
        return this.rawClient.listByCourierOrgIdV1().thenApply(response -> response.body());
    }

    /**
     * Lists all driver rate sheets for the authenticated courier organization.
     */
    public CompletableFuture<List<CourierPayDriverRateSheet1>> listByCourierOrgIdV1(RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves all rate sheets assigned to a specific driver.
     */
    public CompletableFuture<List<CourierPayDriverRateSheet1>> listByDriverIdV1(String driverId) {
        return this.rawClient.listByDriverIdV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Retrieves all rate sheets assigned to a specific driver.
     */
    public CompletableFuture<List<CourierPayDriverRateSheet1>> listByDriverIdV1(
            String driverId, RequestOptions requestOptions) {
        return this.rawClient.listByDriverIdV1(driverId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver rate sheet for calculating courier payments.
     */
    public CompletableFuture<String> createV1(CourierPayDriverRateSheetClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver rate sheet for calculating courier payments.
     */
    public CompletableFuture<String> createV1(
            CourierPayDriverRateSheetClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single rate sheet by its ID.
     */
    public CompletableFuture<CourierPayDriverRateSheet1> getV1(String id) {
        return this.rawClient.getV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a single rate sheet by its ID.
     */
    public CompletableFuture<CourierPayDriverRateSheet1> getV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a driver rate sheet owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes a driver rate sheet owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates an existing driver rate sheet owned by the authenticated organization.
     */
    public CompletableFuture<CourierPayDriverRateSheet1> updateByIdV1(String id) {
        return this.rawClient.updateByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Updates an existing driver rate sheet owned by the authenticated organization.
     */
    public CompletableFuture<CourierPayDriverRateSheet1> updateByIdV1(
            String id, CourierPayDriverRateSheetClientUpdate1 request) {
        return this.rawClient.updateByIdV1(id, request).thenApply(response -> response.body());
    }

    /**
     * Updates an existing driver rate sheet owned by the authenticated organization.
     */
    public CompletableFuture<CourierPayDriverRateSheet1> updateByIdV1(
            String id, CourierPayDriverRateSheetClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateByIdV1(id, request, requestOptions).thenApply(response -> response.body());
    }
}
