/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.dev;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.dev.requests.TemplateReq;
import com.chrt.api.types.DecodedJwtWithOrgAndUserId;
import com.chrt.api.types.TemplateRes;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncDevClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDevClient rawClient;

    public AsyncDevClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDevClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDevClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Experimental endpoint for running AI agentic workflows. Returns the authenticated user's ID for testing purposes. | () -&gt; (str)
     */
    public CompletableFuture<String> getAgentV1() {
        return this.rawClient.getAgentV1().thenApply(response -> response.body());
    }

    /**
     * Experimental endpoint for running AI agentic workflows. Returns the authenticated user's ID for testing purposes. | () -&gt; (str)
     */
    public CompletableFuture<String> getAgentV1(RequestOptions requestOptions) {
        return this.rawClient.getAgentV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * (DEPRECATED) Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public CompletableFuture<String> getUserIdV1() {
        return this.rawClient.getUserIdV1().thenApply(response -> response.body());
    }

    /**
     * (DEPRECATED) Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public CompletableFuture<String> getUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public CompletableFuture<String> getUserIdV2() {
        return this.rawClient.getUserIdV2().thenApply(response -> response.body());
    }

    /**
     * Extracts and returns the user ID from the authenticated request's JWT token. | () -&gt; (str)
     */
    public CompletableFuture<String> getUserIdV2(RequestOptions requestOptions) {
        return this.rawClient.getUserIdV2(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the complete decoded JWT token information for development purposes. | () -&gt; (DecodedJWTWithOrgAndUserId)
     */
    public CompletableFuture<DecodedJwtWithOrgAndUserId> getDecodedJwtV1() {
        return this.rawClient.getDecodedJwtV1().thenApply(response -> response.body());
    }

    /**
     * Returns the complete decoded JWT token information for development purposes. | () -&gt; (DecodedJWTWithOrgAndUserId)
     */
    public CompletableFuture<DecodedJwtWithOrgAndUserId> getDecodedJwtV1(RequestOptions requestOptions) {
        return this.rawClient.getDecodedJwtV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves the primary email address for the authenticated user from the authentication service. | () -&gt; (str)
     */
    public CompletableFuture<String> getEmailV1() {
        return this.rawClient.getEmailV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves the primary email address for the authenticated user from the authentication service. | () -&gt; (str)
     */
    public CompletableFuture<String> getEmailV1(RequestOptions requestOptions) {
        return this.rawClient.getEmailV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Experimental endpoint for running durable execution workflows. Returns the authenticated user's ID for testing purposes. | () -&gt; (dict[str, Any])
     */
    public CompletableFuture<Map<String, Object>> getDurableV1() {
        return this.rawClient.getDurableV1().thenApply(response -> response.body());
    }

    /**
     * Experimental endpoint for running durable execution workflows. Returns the authenticated user's ID for testing purposes. | () -&gt; (dict[str, Any])
     */
    public CompletableFuture<Map<String, Object>> getDurableV1(RequestOptions requestOptions) {
        return this.rawClient.getDurableV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Development template endpoint that returns the authenticated user's ID for testing. | () -&gt; (str)
     */
    public CompletableFuture<String> getTemplateV1() {
        return this.rawClient.getTemplateV1().thenApply(response -> response.body());
    }

    /**
     * Development template endpoint that returns the authenticated user's ID for testing. | () -&gt; (str)
     */
    public CompletableFuture<String> getTemplateV1(RequestOptions requestOptions) {
        return this.rawClient.getTemplateV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Development template endpoint that demonstrates transaction handling and request mirroring. | (TemplateReq) -&gt; (TemplateRes)
     */
    public CompletableFuture<TemplateRes> createTemplateV1(TemplateReq request) {
        return this.rawClient.createTemplateV1(request).thenApply(response -> response.body());
    }

    /**
     * Development template endpoint that demonstrates transaction handling and request mirroring. | (TemplateReq) -&gt; (TemplateRes)
     */
    public CompletableFuture<TemplateRes> createTemplateV1(TemplateReq request, RequestOptions requestOptions) {
        return this.rawClient.createTemplateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns the current GitHub PR number and commit hash for the deployment. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<Map<String, String>> getGitInfoV1() {
        return this.rawClient.getGitInfoV1().thenApply(response -> response.body());
    }

    /**
     * Returns the current GitHub PR number and commit hash for the deployment. | () -&gt; (dict[str, str])
     */
    public CompletableFuture<Map<String, String>> getGitInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getGitInfoV1(requestOptions).thenApply(response -> response.body());
    }
}
