/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.drivers.requests.DriverCreateReq;
import com.chrt.api.resources.drivers.requests.DriverLastSeenReq;
import com.chrt.api.resources.drivers.requests.SetDriverActivationReq;
import com.chrt.api.resources.drivers.requests.UpdateDriverDetailsReq;
import com.chrt.api.types.Driver1;
import com.chrt.api.types.OrgMembersAndDrivers;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncDriversClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDriversClient rawClient;

    public AsyncDriversClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDriversClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDriversClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers.
     */
    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1() {
        return this.rawClient.listOrgMembersAndDriversV1().thenApply(response -> response.body());
    }

    /**
     * Lists all organization members paired with their driver information if they are drivers.
     */
    public CompletableFuture<List<OrgMembersAndDrivers>> listOrgMembersAndDriversV1(RequestOptions requestOptions) {
        return this.rawClient.listOrgMembersAndDriversV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all drivers belonging to the authenticated organization.
     */
    public CompletableFuture<List<Driver1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all drivers belonging to the authenticated organization.
     */
    public CompletableFuture<List<Driver1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver profile for an organization member with optional vehicle type assignments.
     */
    public CompletableFuture<String> createV1(DriverCreateReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a new driver profile for an organization member with optional vehicle type assignments.
     */
    public CompletableFuture<String> createV1(DriverCreateReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves driver information for the authenticated user within their organization.
     */
    public CompletableFuture<Driver1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves driver information for the authenticated user within their organization.
     */
    public CompletableFuture<Driver1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization.
     */
    public CompletableFuture<Driver1> getByDriverIdV1(String driverId) {
        return this.rawClient.getByDriverIdV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Retrieves detailed driver information by driver ID within the organization.
     */
    public CompletableFuture<Driver1> getByDriverIdV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.getByDriverIdV1(driverId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a driver from the organization and removes them from associated rate sheets.
     */
    public CompletableFuture<Boolean> deleteV1(String driverId) {
        return this.rawClient.deleteV1(driverId).thenApply(response -> response.body());
    }

    /**
     * Deletes a driver from the organization and removes them from associated rate sheets.
     */
    public CompletableFuture<Boolean> deleteV1(String driverId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(driverId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sets the activation status of a driver (active/inactive) within the organization.
     */
    public CompletableFuture<Boolean> setActivationV1(SetDriverActivationReq request) {
        return this.rawClient.setActivationV1(request).thenApply(response -> response.body());
    }

    /**
     * Sets the activation status of a driver (active/inactive) within the organization.
     */
    public CompletableFuture<Boolean> setActivationV1(SetDriverActivationReq request, RequestOptions requestOptions) {
        return this.rawClient.setActivationV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the driver's last known location and timestamp for tracking purposes.
     */
    public CompletableFuture<Boolean> lastSeenV1(DriverLastSeenReq request) {
        return this.rawClient.lastSeenV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the driver's last known location and timestamp for tracking purposes.
     */
    public CompletableFuture<Boolean> lastSeenV1(DriverLastSeenReq request, RequestOptions requestOptions) {
        return this.rawClient.lastSeenV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Clears the driver's last known location and timestamp.
     */
    public CompletableFuture<Boolean> lastSeenClearV1() {
        return this.rawClient.lastSeenClearV1().thenApply(response -> response.body());
    }

    /**
     * Clears the driver's last known location and timestamp.
     */
    public CompletableFuture<Boolean> lastSeenClearV1(RequestOptions requestOptions) {
        return this.rawClient.lastSeenClearV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates driver contact details and vehicle type assignments within the organization.
     */
    public CompletableFuture<Boolean> updateDriverV1(UpdateDriverDetailsReq request) {
        return this.rawClient.updateDriverV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates driver contact details and vehicle type assignments within the organization.
     */
    public CompletableFuture<Boolean> updateDriverV1(UpdateDriverDetailsReq request, RequestOptions requestOptions) {
        return this.rawClient.updateDriverV1(request, requestOptions).thenApply(response -> response.body());
    }
}
