/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrgMemberDetails;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DriverCreateReq.Builder.class)
public final class DriverCreateReq {
    private final OrgMemberDetails orgMember;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Map<String, Object> additionalProperties;

    private DriverCreateReq(
            OrgMemberDetails orgMember,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Map<String, Object> additionalProperties) {
        this.orgMember = orgMember;
        this.vehicleTypes = vehicleTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("org_member")
    public OrgMemberDetails getOrgMember() {
        return orgMember;
    }

    @JsonIgnore
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        if (vehicleTypes == null) {
            return Optional.empty();
        }
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("vehicle_types")
    private Optional<List<VehicleTypeEnum>> _getVehicleTypes() {
        return vehicleTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DriverCreateReq && equalTo((DriverCreateReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DriverCreateReq other) {
        return orgMember.equals(other.orgMember) && vehicleTypes.equals(other.vehicleTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orgMember, this.vehicleTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrgMemberStage builder() {
        return new Builder();
    }

    public interface OrgMemberStage {
        _FinalStage orgMember(@NotNull OrgMemberDetails orgMember);

        Builder from(DriverCreateReq other);
    }

    public interface _FinalStage {
        DriverCreateReq build();

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);

        _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrgMemberStage, _FinalStage {
        private OrgMemberDetails orgMember;

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DriverCreateReq other) {
            orgMember(other.getOrgMember());
            vehicleTypes(other.getVehicleTypes());
            return this;
        }

        @java.lang.Override
        @JsonSetter("org_member")
        public _FinalStage orgMember(@NotNull OrgMemberDetails orgMember) {
            this.orgMember = Objects.requireNonNull(orgMember, "orgMember must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes) {
            if (vehicleTypes.isNull()) {
                this.vehicleTypes = null;
            } else if (vehicleTypes.isEmpty()) {
                this.vehicleTypes = Optional.empty();
            } else {
                this.vehicleTypes = Optional.of(vehicleTypes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public DriverCreateReq build() {
            return new DriverCreateReq(orgMember, vehicleTypes, additionalProperties);
        }
    }
}
