/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.drivers.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateDriverDetailsReq.Builder.class)
public final class UpdateDriverDetailsReq {
    private final String driverObjectId;

    private final Optional<String> emailAddressPrimary;

    private final Optional<String> emailAddressSecondary;

    private final Optional<String> phoneNumberPrimary;

    private final Optional<String> phoneNumberSecondary;

    private final Optional<List<VehicleTypeEnum>> vehicleTypes;

    private final Map<String, Object> additionalProperties;

    private UpdateDriverDetailsReq(
            String driverObjectId,
            Optional<String> emailAddressPrimary,
            Optional<String> emailAddressSecondary,
            Optional<String> phoneNumberPrimary,
            Optional<String> phoneNumberSecondary,
            Optional<List<VehicleTypeEnum>> vehicleTypes,
            Map<String, Object> additionalProperties) {
        this.driverObjectId = driverObjectId;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.vehicleTypes = vehicleTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("driver_object_id")
    public String getDriverObjectId() {
        return driverObjectId;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (emailAddressPrimary == null) {
            return Optional.empty();
        }
        return emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (emailAddressSecondary == null) {
            return Optional.empty();
        }
        return emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        if (vehicleTypes == null) {
            return Optional.empty();
        }
        return vehicleTypes;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return emailAddressPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return emailAddressSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return phoneNumberPrimary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return phoneNumberSecondary;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("vehicle_types")
    private Optional<List<VehicleTypeEnum>> _getVehicleTypes() {
        return vehicleTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateDriverDetailsReq && equalTo((UpdateDriverDetailsReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateDriverDetailsReq other) {
        return driverObjectId.equals(other.driverObjectId)
                && emailAddressPrimary.equals(other.emailAddressPrimary)
                && emailAddressSecondary.equals(other.emailAddressSecondary)
                && phoneNumberPrimary.equals(other.phoneNumberPrimary)
                && phoneNumberSecondary.equals(other.phoneNumberSecondary)
                && vehicleTypes.equals(other.vehicleTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.driverObjectId,
                this.emailAddressPrimary,
                this.emailAddressSecondary,
                this.phoneNumberPrimary,
                this.phoneNumberSecondary,
                this.vehicleTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DriverObjectIdStage builder() {
        return new Builder();
    }

    public interface DriverObjectIdStage {
        _FinalStage driverObjectId(@NotNull String driverObjectId);

        Builder from(UpdateDriverDetailsReq other);
    }

    public interface _FinalStage {
        UpdateDriverDetailsReq build();

        _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary);

        _FinalStage emailAddressPrimary(String emailAddressPrimary);

        _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary);

        _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary);

        _FinalStage emailAddressSecondary(String emailAddressSecondary);

        _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary);

        _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(String phoneNumberPrimary);

        _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary);

        _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(String phoneNumberSecondary);

        _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary);

        _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes);

        _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes);

        _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DriverObjectIdStage, _FinalStage {
        private String driverObjectId;

        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();

        private Optional<String> phoneNumberSecondary = Optional.empty();

        private Optional<String> phoneNumberPrimary = Optional.empty();

        private Optional<String> emailAddressSecondary = Optional.empty();

        private Optional<String> emailAddressPrimary = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateDriverDetailsReq other) {
            driverObjectId(other.getDriverObjectId());
            emailAddressPrimary(other.getEmailAddressPrimary());
            emailAddressSecondary(other.getEmailAddressSecondary());
            phoneNumberPrimary(other.getPhoneNumberPrimary());
            phoneNumberSecondary(other.getPhoneNumberSecondary());
            vehicleTypes(other.getVehicleTypes());
            return this;
        }

        @java.lang.Override
        @JsonSetter("driver_object_id")
        public _FinalStage driverObjectId(@NotNull String driverObjectId) {
            this.driverObjectId = Objects.requireNonNull(driverObjectId, "driverObjectId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(Nullable<List<VehicleTypeEnum>> vehicleTypes) {
            if (vehicleTypes.isNull()) {
                this.vehicleTypes = null;
            } else if (vehicleTypes.isEmpty()) {
                this.vehicleTypes = Optional.empty();
            } else {
                this.vehicleTypes = Optional.of(vehicleTypes.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "vehicle_types", nulls = Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            if (phoneNumberSecondary.isNull()) {
                this.phoneNumberSecondary = null;
            } else if (phoneNumberSecondary.isEmpty()) {
                this.phoneNumberSecondary = Optional.empty();
            } else {
                this.phoneNumberSecondary = Optional.of(phoneNumberSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_secondary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            if (phoneNumberPrimary.isNull()) {
                this.phoneNumberPrimary = null;
            } else if (phoneNumberPrimary.isEmpty()) {
                this.phoneNumberPrimary = Optional.empty();
            } else {
                this.phoneNumberPrimary = Optional.of(phoneNumberPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "phone_number_primary", nulls = Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            if (emailAddressSecondary.isNull()) {
                this.emailAddressSecondary = null;
            } else if (emailAddressSecondary.isEmpty()) {
                this.emailAddressSecondary = Optional.empty();
            } else {
                this.emailAddressSecondary = Optional.of(emailAddressSecondary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_secondary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            if (emailAddressPrimary.isNull()) {
                this.emailAddressPrimary = null;
            } else if (emailAddressPrimary.isEmpty()) {
                this.emailAddressPrimary = Optional.empty();
            } else {
                this.emailAddressPrimary = Optional.of(emailAddressPrimary.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "email_address_primary", nulls = Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @java.lang.Override
        public UpdateDriverDetailsReq build() {
            return new UpdateDriverDetailsReq(
                    driverObjectId,
                    emailAddressPrimary,
                    emailAddressSecondary,
                    phoneNumberPrimary,
                    phoneNumberSecondary,
                    vehicleTypes,
                    additionalProperties);
        }
    }
}
