/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.offchrtshipperorg;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.offchrtshipperorg.requests.OffChrtShipperOrgClientCreate1;
import com.chrt.api.resources.offchrtshipperorg.requests.OffChrtShipperOrgClientUpdate1;
import com.chrt.api.types.OffChrtShipperOrg1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncOffChrtShipperOrgClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOffChrtShipperOrgClient rawClient;

    public AsyncOffChrtShipperOrgClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOffChrtShipperOrgClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOffChrtShipperOrgClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates an off-platform shipper organization record.
     */
    public CompletableFuture<String> createV1(OffChrtShipperOrgClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates an off-platform shipper organization record.
     */
    public CompletableFuture<String> createV1(OffChrtShipperOrgClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all off-platform shipper organizations created by the authenticated organization.
     */
    public CompletableFuture<List<OffChrtShipperOrg1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all off-platform shipper organizations created by the authenticated organization.
     */
    public CompletableFuture<List<OffChrtShipperOrg1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves specific off-platform shipper organization by ID.
     */
    public CompletableFuture<OffChrtShipperOrg1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves specific off-platform shipper organization by ID.
     */
    public CompletableFuture<OffChrtShipperOrg1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes off-platform shipper organization owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes off-platform shipper organization owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateByIdV1(String id) {
        return this.rawClient.updateByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateByIdV1(String id, OffChrtShipperOrgClientUpdate1 request) {
        return this.rawClient.updateByIdV1(id, request).thenApply(response -> response.body());
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateByIdV1(
            String id, OffChrtShipperOrgClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateByIdV1(id, request, requestOptions).thenApply(response -> response.body());
    }
}
