/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.offchrtshipperorg;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.offchrtshipperorg.requests.OffChrtShipperOrgClientCreate1;
import com.chrt.api.resources.offchrtshipperorg.requests.OffChrtShipperOrgClientUpdate1;
import com.chrt.api.types.OffChrtShipperOrg1;
import java.util.List;

public class OffChrtShipperOrgClient {
    protected final ClientOptions clientOptions;

    private final RawOffChrtShipperOrgClient rawClient;

    public OffChrtShipperOrgClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOffChrtShipperOrgClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawOffChrtShipperOrgClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates an off-platform shipper organization record.
     */
    public String createV1(OffChrtShipperOrgClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates an off-platform shipper organization record.
     */
    public String createV1(OffChrtShipperOrgClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Lists all off-platform shipper organizations created by the authenticated organization.
     */
    public List<OffChrtShipperOrg1> listV1() {
        return this.rawClient.listV1().body();
    }

    /**
     * Lists all off-platform shipper organizations created by the authenticated organization.
     */
    public List<OffChrtShipperOrg1> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).body();
    }

    /**
     * Retrieves specific off-platform shipper organization by ID.
     */
    public OffChrtShipperOrg1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    /**
     * Retrieves specific off-platform shipper organization by ID.
     */
    public OffChrtShipperOrg1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    /**
     * Deletes off-platform shipper organization owned by the authenticated organization.
     */
    public boolean deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).body();
    }

    /**
     * Deletes off-platform shipper organization owned by the authenticated organization.
     */
    public boolean deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).body();
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public boolean updateByIdV1(String id) {
        return this.rawClient.updateByIdV1(id).body();
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public boolean updateByIdV1(String id, OffChrtShipperOrgClientUpdate1 request) {
        return this.rawClient.updateByIdV1(id, request).body();
    }

    /**
     * Updates existing off-platform shipper organization owned by the authenticated organization.
     */
    public boolean updateByIdV1(String id, OffChrtShipperOrgClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateByIdV1(id, request, requestOptions).body();
    }
}
