/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orderdrafts.cargo.CargoClient;
import com.chrt.api.resources.orderdrafts.requests.OrderDraftExpandedListReq;
import com.chrt.api.resources.orderdrafts.requests.OrderDraftExpandedReq;
import com.chrt.api.resources.orderdrafts.requests.OrdersDraftUpdateReq;
import com.chrt.api.resources.orderdrafts.requests.OrdersNewDraftReq;
import com.chrt.api.resources.orderdrafts.task.TaskClient;
import com.chrt.api.resources.orderdrafts.taskartifact.TaskArtifactClient;
import com.chrt.api.resources.orderdrafts.taskgroup.TaskGroupClient;
import com.chrt.api.types.OrderDraftExpandedListRes;
import com.chrt.api.types.OrderDraftExpandedRes;
import com.chrt.api.types.OrdersDraftUpdateRes;
import com.chrt.api.types.OrdersNewDraftRes;
import java.util.function.Supplier;

public class OrderDraftsClient {
    protected final ClientOptions clientOptions;

    private final RawOrderDraftsClient rawClient;

    protected final Supplier<TaskGroupClient> taskGroupClient;

    protected final Supplier<TaskClient> taskClient;

    protected final Supplier<TaskArtifactClient> taskArtifactClient;

    protected final Supplier<CargoClient> cargoClient;

    public OrderDraftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrderDraftsClient(clientOptions);
        this.taskGroupClient = Suppliers.memoize(() -> new TaskGroupClient(clientOptions));
        this.taskClient = Suppliers.memoize(() -> new TaskClient(clientOptions));
        this.taskArtifactClient = Suppliers.memoize(() -> new TaskArtifactClient(clientOptions));
        this.cargoClient = Suppliers.memoize(() -> new CargoClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawOrderDraftsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type.
     */
    public OrdersNewDraftRes newV1() {
        return this.rawClient.newV1().body();
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type.
     */
    public OrdersNewDraftRes newV1(OrdersNewDraftReq request) {
        return this.rawClient.newV1(request).body();
    }

    /**
     * Creates a new draft order with org assignments based on caller's organization type.
     */
    public OrdersNewDraftRes newV1(OrdersNewDraftReq request, RequestOptions requestOptions) {
        return this.rawClient.newV1(request, requestOptions).body();
    }

    /**
     * Updates forwarder and/or shipper org assignments for a draft order
     */
    public OrdersDraftUpdateRes updateV1(OrdersDraftUpdateReq request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates forwarder and/or shipper org assignments for a draft order
     */
    public OrdersDraftUpdateRes updateV1(OrdersDraftUpdateReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }

    /**
     * Deletes a draft order and all associated entities
     */
    public boolean deleteV1(String orderId) {
        return this.rawClient.deleteV1(orderId).body();
    }

    /**
     * Deletes a draft order and all associated entities
     */
    public boolean deleteV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(orderId, requestOptions).body();
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it.
     */
    public OrderDraftExpandedRes expandedV1(String orderIdOrShortId) {
        return this.rawClient.expandedV1(orderIdOrShortId).body();
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it.
     */
    public OrderDraftExpandedRes expandedV1(String orderIdOrShortId, OrderDraftExpandedReq request) {
        return this.rawClient.expandedV1(orderIdOrShortId, request).body();
    }

    /**
     * Fetches a single draft order with optional expanded related data. Only the creator of the draft order can access it.
     */
    public OrderDraftExpandedRes expandedV1(
            String orderIdOrShortId, OrderDraftExpandedReq request, RequestOptions requestOptions) {
        return this.rawClient
                .expandedV1(orderIdOrShortId, request, requestOptions)
                .body();
    }

    /**
     * Lists all draft orders created by the authenticated user with optional expanded related data.
     */
    public OrderDraftExpandedListRes expandedListV1() {
        return this.rawClient.expandedListV1().body();
    }

    /**
     * Lists all draft orders created by the authenticated user with optional expanded related data.
     */
    public OrderDraftExpandedListRes expandedListV1(OrderDraftExpandedListReq request) {
        return this.rawClient.expandedListV1(request).body();
    }

    /**
     * Lists all draft orders created by the authenticated user with optional expanded related data.
     */
    public OrderDraftExpandedListRes expandedListV1(OrderDraftExpandedListReq request, RequestOptions requestOptions) {
        return this.rawClient.expandedListV1(request, requestOptions).body();
    }

    /**
     * Checks whether the draft order satisfies all requirements to move into staging.
     */
    public boolean validateV1(String orderId) {
        return this.rawClient.validateV1(orderId).body();
    }

    /**
     * Checks whether the draft order satisfies all requirements to move into staging.
     */
    public boolean validateV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.validateV1(orderId, requestOptions).body();
    }

    public TaskGroupClient taskGroup() {
        return this.taskGroupClient.get();
    }

    public TaskClient task() {
        return this.taskClient.get();
    }

    public TaskArtifactClient taskArtifact() {
        return this.taskArtifactClient.get();
    }

    public CargoClient cargo() {
        return this.cargoClient.get();
    }
}
