/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.cargo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftAddCargoReq;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftAssociateCargoWithTaskReq;
import com.chrt.api.resources.orderdrafts.cargo.requests.OrderDraftUpdateCargoReq;
import java.util.concurrent.CompletableFuture;

public class AsyncCargoClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCargoClient rawClient;

    public AsyncCargoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCargoClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCargoClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a cargo item to an existing draft order. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> addV1(OrderDraftAddCargoReq request) {
        return this.rawClient.addV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a cargo item to an existing draft order. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> addV1(OrderDraftAddCargoReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Associates existing cargo with a task in a draft order.
     */
    public CompletableFuture<Boolean> associateWithTaskV1(OrderDraftAssociateCargoWithTaskReq request) {
        return this.rawClient.associateWithTaskV1(request).thenApply(response -> response.body());
    }

    /**
     * Associates existing cargo with a task in a draft order.
     */
    public CompletableFuture<Boolean> associateWithTaskV1(
            OrderDraftAssociateCargoWithTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.associateWithTaskV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates a cargo item in an existing draft order. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> updateV1(OrderDraftUpdateCargoReq request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates a cargo item in an existing draft order. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> updateV1(OrderDraftUpdateCargoReq request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a cargo item from a draft order and removes references from associated tasks
     */
    public CompletableFuture<Boolean> deleteV1(String cargoId) {
        return this.rawClient.deleteV1(cargoId).thenApply(response -> response.body());
    }

    /**
     * Deletes a cargo item from a draft order and removes references from associated tasks
     */
    public CompletableFuture<Boolean> deleteV1(String cargoId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(cargoId, requestOptions).thenApply(response -> response.body());
    }
}
