/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.task.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.TaskClientCreate1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OrderDraftAddTaskReqV1.Builder.class)
public final class OrderDraftAddTaskReqV1 {
    private final String taskGroupId;

    private final TaskClientCreate1 task;

    private final Optional<List<String>> cargoIds;

    private final Map<String, Object> additionalProperties;

    private OrderDraftAddTaskReqV1(
            String taskGroupId,
            TaskClientCreate1 task,
            Optional<List<String>> cargoIds,
            Map<String, Object> additionalProperties) {
        this.taskGroupId = taskGroupId;
        this.task = task;
        this.cargoIds = cargoIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("task_group_id")
    public String getTaskGroupId() {
        return taskGroupId;
    }

    @JsonProperty("task")
    public TaskClientCreate1 getTask() {
        return task;
    }

    @JsonIgnore
    public Optional<List<String>> getCargoIds() {
        if (cargoIds == null) {
            return Optional.empty();
        }
        return cargoIds;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("cargo_ids")
    private Optional<List<String>> _getCargoIds() {
        return cargoIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OrderDraftAddTaskReqV1 && equalTo((OrderDraftAddTaskReqV1) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftAddTaskReqV1 other) {
        return taskGroupId.equals(other.taskGroupId) && task.equals(other.task) && cargoIds.equals(other.cargoIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.taskGroupId, this.task, this.cargoIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskGroupIdStage builder() {
        return new Builder();
    }

    public interface TaskGroupIdStage {
        TaskStage taskGroupId(@NotNull String taskGroupId);

        Builder from(OrderDraftAddTaskReqV1 other);
    }

    public interface TaskStage {
        _FinalStage task(@NotNull TaskClientCreate1 task);
    }

    public interface _FinalStage {
        OrderDraftAddTaskReqV1 build();

        _FinalStage cargoIds(Optional<List<String>> cargoIds);

        _FinalStage cargoIds(List<String> cargoIds);

        _FinalStage cargoIds(Nullable<List<String>> cargoIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TaskGroupIdStage, TaskStage, _FinalStage {
        private String taskGroupId;

        private TaskClientCreate1 task;

        private Optional<List<String>> cargoIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(OrderDraftAddTaskReqV1 other) {
            taskGroupId(other.getTaskGroupId());
            task(other.getTask());
            cargoIds(other.getCargoIds());
            return this;
        }

        @java.lang.Override
        @JsonSetter("task_group_id")
        public TaskStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("task")
        public _FinalStage task(@NotNull TaskClientCreate1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoIds(Nullable<List<String>> cargoIds) {
            if (cargoIds.isNull()) {
                this.cargoIds = null;
            } else if (cargoIds.isEmpty()) {
                this.cargoIds = Optional.empty();
            } else {
                this.cargoIds = Optional.of(cargoIds.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage cargoIds(List<String> cargoIds) {
            this.cargoIds = Optional.ofNullable(cargoIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "cargo_ids", nulls = Nulls.SKIP)
        public _FinalStage cargoIds(Optional<List<String>> cargoIds) {
            this.cargoIds = cargoIds;
            return this;
        }

        @java.lang.Override
        public OrderDraftAddTaskReqV1 build() {
            return new OrderDraftAddTaskReqV1(taskGroupId, task, cargoIds, additionalProperties);
        }
    }
}
