/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskartifact;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskartifact.requests.OrderDraftAddTaskArtifactReq;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskArtifactClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskArtifactClient rawClient;

    public AsyncTaskArtifactClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskArtifactClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskArtifactClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task artifact to an existing task in a draft order.
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskArtifactReq request) {
        return this.rawClient.addV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a task artifact to an existing task in a draft order.
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskArtifactReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a task artifact from a draft order and removes it from the associated task.
     */
    public CompletableFuture<Boolean> deleteV1(String taskArtifactId) {
        return this.rawClient.deleteV1(taskArtifactId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task artifact from a draft order and removes it from the associated task.
     */
    public CompletableFuture<Boolean> deleteV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskArtifactId, requestOptions).thenApply(response -> response.body());
    }
}
