/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.OrderDraftAddTaskGroupReq;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskGroupClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskGroupClient rawClient;

    public AsyncTaskGroupClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskGroupClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskGroupClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request) {
        return this.rawClient.addV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller.
     */
    public CompletableFuture<String> addV1(OrderDraftAddTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order.
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupId) {
        return this.rawClient.deleteV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order.
     */
    public CompletableFuture<Boolean> deleteV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }
}
