/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orderdrafts.taskgroup;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orderdrafts.taskgroup.requests.OrderDraftAddTaskGroupReq;

public class TaskGroupClient {
    protected final ClientOptions clientOptions;

    private final RawTaskGroupClient rawClient;

    public TaskGroupClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskGroupClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskGroupClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller.
     */
    public String addV1(OrderDraftAddTaskGroupReq request) {
        return this.rawClient.addV1(request).body();
    }

    /**
     * Adds a task group to an existing order draft. Validates order is in DRAFT status and owned by caller.
     */
    public String addV1(OrderDraftAddTaskGroupReq request, RequestOptions requestOptions) {
        return this.rawClient.addV1(request, requestOptions).body();
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order.
     */
    public boolean deleteV1(String taskGroupId) {
        return this.rawClient.deleteV1(taskGroupId).body();
    }

    /**
     * Deletes a task group and all associated entities (tasks, task artifacts, S3 metadata). The task group must belong to a DRAFT order.
     */
    public boolean deleteV1(String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.deleteV1(taskGroupId, requestOptions).body();
    }
}
