/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.orders.expanded.AsyncExpandedClient;
import com.chrt.api.resources.orders.expandedlist.AsyncExpandedListClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncOrdersClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOrdersClient rawClient;

    protected final Supplier<AsyncExpandedClient> expandedClient;

    protected final Supplier<AsyncExpandedListClient> expandedListClient;

    public AsyncOrdersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrdersClient(clientOptions);
        this.expandedClient = Suppliers.memoize(() -> new AsyncExpandedClient(clientOptions));
        this.expandedListClient = Suppliers.memoize(() -> new AsyncExpandedListClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOrdersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Validates a draft order and stages all related entities in a transaction.
     */
    public CompletableFuture<Boolean> stageV1(String orderId) {
        return this.rawClient.stageV1(orderId).thenApply(response -> response.body());
    }

    /**
     * Validates a draft order and stages all related entities in a transaction.
     */
    public CompletableFuture<Boolean> stageV1(String orderId, RequestOptions requestOptions) {
        return this.rawClient.stageV1(orderId, requestOptions).thenApply(response -> response.body());
    }

    public AsyncExpandedClient expanded() {
        return this.expandedClient.get();
    }

    public AsyncExpandedListClient expandedList() {
        return this.expandedListClient.get();
    }
}
