/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.OrderExpandedForOrderCreator;
import com.chrt.api.types.OrderExpandedForOrderCreatorReq;
import com.chrt.api.types.OrderExpandedForShipper;
import com.chrt.api.types.OrderExpandedForShipperReq;

public class ExpandedClient {
    protected final ClientOptions clientOptions;

    private final RawExpandedClient rawClient;

    public ExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawExpandedClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawExpandedClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public OrderExpandedForShipper postForShipperByOrderIdV1(String orderIdOrShortId) {
        return this.rawClient.postForShipperByOrderIdV1(orderIdOrShortId).body();
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public OrderExpandedForShipper postForShipperByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForShipperReq request) {
        return this.rawClient
                .postForShipperByOrderIdV1(orderIdOrShortId, request)
                .body();
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public OrderExpandedForShipper postForShipperByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForShipperReq request, RequestOptions requestOptions) {
        return this.rawClient
                .postForShipperByOrderIdV1(orderIdOrShortId, request, requestOptions)
                .body();
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public OrderExpandedForOrderCreator postForOrderCreatorByOrderIdV1(String orderIdOrShortId) {
        return this.rawClient.postForOrderCreatorByOrderIdV1(orderIdOrShortId).body();
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public OrderExpandedForOrderCreator postForOrderCreatorByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForOrderCreatorReq request) {
        return this.rawClient
                .postForOrderCreatorByOrderIdV1(orderIdOrShortId, request)
                .body();
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public OrderExpandedForOrderCreator postForOrderCreatorByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForOrderCreatorReq request, RequestOptions requestOptions) {
        return this.rawClient
                .postForOrderCreatorByOrderIdV1(orderIdOrShortId, request, requestOptions)
                .body();
    }
}
