/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expanded;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrderExpandedForOrderCreator;
import com.chrt.api.types.OrderExpandedForOrderCreatorReq;
import com.chrt.api.types.OrderExpandedForShipper;
import com.chrt.api.types.OrderExpandedForShipperReq;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawExpandedClient {
    protected final ClientOptions clientOptions;

    public RawExpandedClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForShipper> postForShipperByOrderIdV1(String orderIdOrShortId) {
        return postForShipperByOrderIdV1(
                orderIdOrShortId, OrderExpandedForShipperReq.builder().build());
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForShipper> postForShipperByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForShipperReq request) {
        return postForShipperByOrderIdV1(orderIdOrShortId, request, null);
    }

    /**
     * Fetches a single order for the shipper organization with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForShipper> postForShipperByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForShipperReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/for_shipper/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpandedForShipper.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForOrderCreator> postForOrderCreatorByOrderIdV1(String orderIdOrShortId) {
        return postForOrderCreatorByOrderIdV1(
                orderIdOrShortId, OrderExpandedForOrderCreatorReq.builder().build());
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForOrderCreator> postForOrderCreatorByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForOrderCreatorReq request) {
        return postForOrderCreatorByOrderIdV1(orderIdOrShortId, request, null);
    }

    /**
     * Fetches a single order for the organization that created it with optional expanded related data.
     */
    public ChrtApiHttpResponse<OrderExpandedForOrderCreator> postForOrderCreatorByOrderIdV1(
            String orderIdOrShortId, OrderExpandedForOrderCreatorReq request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/for_order_creator/v1")
                .addPathSegment(orderIdOrShortId)
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new ChrtApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new ChrtApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, OrderExpandedForOrderCreator.class),
                        response);
            }
            try {
                if (response.code() == 422) {
                    throw new UnprocessableEntityError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                            response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new ChrtApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new ChrtApiException("Network error executing HTTP request", e);
        }
    }
}
