/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expandedlist;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orders.expandedlist.requests.ExpandedListPostOrderCreatorExpandedListV1Request;
import com.chrt.api.resources.orders.expandedlist.requests.ExpandedListPostShipperExpandedListV1Request;
import com.chrt.api.types.OrdersExpandedForOrderCreatorRes;
import com.chrt.api.types.OrdersExpandedForShipperRes;
import java.util.concurrent.CompletableFuture;

public class AsyncExpandedListClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawExpandedListClient rawClient;

    public AsyncExpandedListClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawExpandedListClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawExpandedListClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves orders expanded list for the shipper organization with optional filters and related data.
     */
    public CompletableFuture<OrdersExpandedForShipperRes> postShipperExpandedListV1(
            ExpandedListPostShipperExpandedListV1Request request) {
        return this.rawClient.postShipperExpandedListV1(request).thenApply(response -> response.body());
    }

    /**
     * Retrieves orders expanded list for the shipper organization with optional filters and related data.
     */
    public CompletableFuture<OrdersExpandedForShipperRes> postShipperExpandedListV1(
            ExpandedListPostShipperExpandedListV1Request request, RequestOptions requestOptions) {
        return this.rawClient.postShipperExpandedListV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves orders expanded list for order creator org with optional filters, shipper includes, and exclusions.
     */
    public CompletableFuture<OrdersExpandedForOrderCreatorRes> postOrderCreatorExpandedListV1(
            ExpandedListPostOrderCreatorExpandedListV1Request request) {
        return this.rawClient.postOrderCreatorExpandedListV1(request).thenApply(response -> response.body());
    }

    /**
     * Retrieves orders expanded list for order creator org with optional filters, shipper includes, and exclusions.
     */
    public CompletableFuture<OrdersExpandedForOrderCreatorRes> postOrderCreatorExpandedListV1(
            ExpandedListPostOrderCreatorExpandedListV1Request request, RequestOptions requestOptions) {
        return this.rawClient
                .postOrderCreatorExpandedListV1(request, requestOptions)
                .thenApply(response -> response.body());
    }
}
