/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expandedlist;

import com.chrt.api.core.ChrtApiApiException;
import com.chrt.api.core.ChrtApiException;
import com.chrt.api.core.ChrtApiHttpResponse;
import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.MediaTypes;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.core.QueryStringMapper;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.errors.UnprocessableEntityError;
import com.chrt.api.resources.orders.expandedlist.requests.ExpandedListPostOrderCreatorExpandedListV1Request;
import com.chrt.api.resources.orders.expandedlist.requests.ExpandedListPostShipperExpandedListV1Request;
import com.chrt.api.types.HttpValidationError;
import com.chrt.api.types.OrdersExpandedForOrderCreatorRes;
import com.chrt.api.types.OrdersExpandedForShipperRes;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawExpandedListClient {
    protected final ClientOptions clientOptions;

    public AsyncRawExpandedListClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Retrieves orders expanded list for the shipper organization with optional filters and related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForShipperRes>> postShipperExpandedListV1(
            ExpandedListPostShipperExpandedListV1Request request) {
        return postShipperExpandedListV1(request, null);
    }

    /**
     * Retrieves orders expanded list for the shipper organization with optional filters and related data.
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForShipperRes>> postShipperExpandedListV1(
            ExpandedListPostShipperExpandedListV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/list/for_shipper/v1");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getFilterDraftStartedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_gte",
                    request.getFilterDraftStartedAtGte().get(),
                    false);
        }
        if (request.getFilterDraftStartedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_lte",
                    request.getFilterDraftStartedAtLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelled().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled",
                    request.getFilterOrderCancelled().get(),
                    false);
        }
        if (request.getFilterStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_statuses", request.getFilterStatuses().get(), true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForShipperRes>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, OrdersExpandedForShipperRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Retrieves orders expanded list for order creator org with optional filters, shipper includes, and exclusions.
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForOrderCreatorRes>> postOrderCreatorExpandedListV1(
            ExpandedListPostOrderCreatorExpandedListV1Request request) {
        return postOrderCreatorExpandedListV1(request, null);
    }

    /**
     * Retrieves orders expanded list for order creator org with optional filters, shipper includes, and exclusions.
     */
    public CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForOrderCreatorRes>> postOrderCreatorExpandedListV1(
            ExpandedListPostOrderCreatorExpandedListV1Request request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("oort/orders/expanded/list/for_order_creator/v1");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPageSize().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "page_size", request.getPageSize().get(), false);
        }
        if (request.getSortBy().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_by", request.getSortBy().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getFilterDraftStartedAtGte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_gte",
                    request.getFilterDraftStartedAtGte().get(),
                    false);
        }
        if (request.getFilterDraftStartedAtLte().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_draft_started_at_lte",
                    request.getFilterDraftStartedAtLte().get(),
                    false);
        }
        if (request.getFilterOrderCancelled().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "filter_order_cancelled",
                    request.getFilterOrderCancelled().get(),
                    false);
        }
        if (request.getFilterStatuses().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "filter_statuses", request.getFilterStatuses().get(), true);
        }
        if (request.getIncludeShipperOrgIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "include_shipper_org_ids",
                    request.getIncludeShipperOrgIds().get(),
                    true);
        }
        if (request.getExcludeShipperOrgIds().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl,
                    "exclude_shipper_org_ids",
                    request.getExcludeShipperOrgIds().get(),
                    true);
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<ChrtApiHttpResponse<OrdersExpandedForOrderCreatorRes>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new ChrtApiHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, OrdersExpandedForOrderCreatorRes.class),
                                response));
                        return;
                    }
                    try {
                        if (response.code() == 422) {
                            future.completeExceptionally(new UnprocessableEntityError(
                                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HttpValidationError.class),
                                    response));
                            return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    future.completeExceptionally(new ChrtApiApiException(
                            "Error with status code " + response.code(),
                            response.code(),
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                            response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new ChrtApiException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
