/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orders.expandedlist.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrderExpandedForShipperReq;
import com.chrt.api.types.OrderExpandedListSortFieldEnum;
import com.chrt.api.types.OrderStatusEnum1;
import com.chrt.api.types.SortOrderEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ExpandedListPostShipperExpandedListV1Request.Builder.class)
public final class ExpandedListPostShipperExpandedListV1Request {
    private final Optional<List<OrderStatusEnum1>> filterStatuses;

    private final Optional<Integer> page;

    private final Optional<Integer> pageSize;

    private final Optional<OrderExpandedListSortFieldEnum> sortBy;

    private final Optional<SortOrderEnum> sortOrder;

    private final Optional<OffsetDateTime> filterDraftStartedAtGte;

    private final Optional<OffsetDateTime> filterDraftStartedAtLte;

    private final Optional<Boolean> filterOrderCancelled;

    private final OrderExpandedForShipperReq body;

    private final Map<String, Object> additionalProperties;

    private ExpandedListPostShipperExpandedListV1Request(
            Optional<List<OrderStatusEnum1>> filterStatuses,
            Optional<Integer> page,
            Optional<Integer> pageSize,
            Optional<OrderExpandedListSortFieldEnum> sortBy,
            Optional<SortOrderEnum> sortOrder,
            Optional<OffsetDateTime> filterDraftStartedAtGte,
            Optional<OffsetDateTime> filterDraftStartedAtLte,
            Optional<Boolean> filterOrderCancelled,
            OrderExpandedForShipperReq body,
            Map<String, Object> additionalProperties) {
        this.filterStatuses = filterStatuses;
        this.page = page;
        this.pageSize = pageSize;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.filterDraftStartedAtGte = filterDraftStartedAtGte;
        this.filterDraftStartedAtLte = filterDraftStartedAtLte;
        this.filterOrderCancelled = filterOrderCancelled;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<OrderStatusEnum1>> getFilterStatuses() {
        if (filterStatuses == null) {
            return Optional.empty();
        }
        return filterStatuses;
    }

    @JsonIgnore
    public Optional<Integer> getPage() {
        if (page == null) {
            return Optional.empty();
        }
        return page;
    }

    @JsonIgnore
    public Optional<Integer> getPageSize() {
        if (pageSize == null) {
            return Optional.empty();
        }
        return pageSize;
    }

    @JsonIgnore
    public Optional<OrderExpandedListSortFieldEnum> getSortBy() {
        if (sortBy == null) {
            return Optional.empty();
        }
        return sortBy;
    }

    @JsonIgnore
    public Optional<SortOrderEnum> getSortOrder() {
        if (sortOrder == null) {
            return Optional.empty();
        }
        return sortOrder;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtGte() {
        if (filterDraftStartedAtGte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtGte;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFilterDraftStartedAtLte() {
        if (filterDraftStartedAtLte == null) {
            return Optional.empty();
        }
        return filterDraftStartedAtLte;
    }

    @JsonIgnore
    public Optional<Boolean> getFilterOrderCancelled() {
        if (filterOrderCancelled == null) {
            return Optional.empty();
        }
        return filterOrderCancelled;
    }

    @JsonProperty("body")
    public OrderExpandedForShipperReq getBody() {
        return body;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_statuses")
    private Optional<List<OrderStatusEnum1>> _getFilterStatuses() {
        return filterStatuses;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page")
    private Optional<Integer> _getPage() {
        return page;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("page_size")
    private Optional<Integer> _getPageSize() {
        return pageSize;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_by")
    private Optional<OrderExpandedListSortFieldEnum> _getSortBy() {
        return sortBy;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("sort_order")
    private Optional<SortOrderEnum> _getSortOrder() {
        return sortOrder;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_gte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtGte() {
        return filterDraftStartedAtGte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_draft_started_at_lte")
    private Optional<OffsetDateTime> _getFilterDraftStartedAtLte() {
        return filterDraftStartedAtLte;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("filter_order_cancelled")
    private Optional<Boolean> _getFilterOrderCancelled() {
        return filterOrderCancelled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ExpandedListPostShipperExpandedListV1Request
                && equalTo((ExpandedListPostShipperExpandedListV1Request) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExpandedListPostShipperExpandedListV1Request other) {
        return filterStatuses.equals(other.filterStatuses)
                && page.equals(other.page)
                && pageSize.equals(other.pageSize)
                && sortBy.equals(other.sortBy)
                && sortOrder.equals(other.sortOrder)
                && filterDraftStartedAtGte.equals(other.filterDraftStartedAtGte)
                && filterDraftStartedAtLte.equals(other.filterDraftStartedAtLte)
                && filterOrderCancelled.equals(other.filterOrderCancelled)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.filterStatuses,
                this.page,
                this.pageSize,
                this.sortBy,
                this.sortOrder,
                this.filterDraftStartedAtGte,
                this.filterDraftStartedAtLte,
                this.filterOrderCancelled,
                this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    public interface BodyStage {
        _FinalStage body(@NotNull OrderExpandedForShipperReq body);

        Builder from(ExpandedListPostShipperExpandedListV1Request other);
    }

    public interface _FinalStage {
        ExpandedListPostShipperExpandedListV1Request build();

        _FinalStage filterStatuses(Optional<List<OrderStatusEnum1>> filterStatuses);

        _FinalStage filterStatuses(List<OrderStatusEnum1> filterStatuses);

        _FinalStage filterStatuses(Nullable<List<OrderStatusEnum1>> filterStatuses);

        _FinalStage filterStatuses(OrderStatusEnum1 filterStatuses);

        _FinalStage page(Optional<Integer> page);

        _FinalStage page(Integer page);

        _FinalStage page(Nullable<Integer> page);

        _FinalStage pageSize(Optional<Integer> pageSize);

        _FinalStage pageSize(Integer pageSize);

        _FinalStage pageSize(Nullable<Integer> pageSize);

        _FinalStage sortBy(Optional<OrderExpandedListSortFieldEnum> sortBy);

        _FinalStage sortBy(OrderExpandedListSortFieldEnum sortBy);

        _FinalStage sortBy(Nullable<OrderExpandedListSortFieldEnum> sortBy);

        _FinalStage sortOrder(Optional<SortOrderEnum> sortOrder);

        _FinalStage sortOrder(SortOrderEnum sortOrder);

        _FinalStage sortOrder(Nullable<SortOrderEnum> sortOrder);

        _FinalStage filterDraftStartedAtGte(Optional<OffsetDateTime> filterDraftStartedAtGte);

        _FinalStage filterDraftStartedAtGte(OffsetDateTime filterDraftStartedAtGte);

        _FinalStage filterDraftStartedAtGte(Nullable<OffsetDateTime> filterDraftStartedAtGte);

        _FinalStage filterDraftStartedAtLte(Optional<OffsetDateTime> filterDraftStartedAtLte);

        _FinalStage filterDraftStartedAtLte(OffsetDateTime filterDraftStartedAtLte);

        _FinalStage filterDraftStartedAtLte(Nullable<OffsetDateTime> filterDraftStartedAtLte);

        _FinalStage filterOrderCancelled(Optional<Boolean> filterOrderCancelled);

        _FinalStage filterOrderCancelled(Boolean filterOrderCancelled);

        _FinalStage filterOrderCancelled(Nullable<Boolean> filterOrderCancelled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BodyStage, _FinalStage {
        private OrderExpandedForShipperReq body;

        private Optional<Boolean> filterOrderCancelled = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtLte = Optional.empty();

        private Optional<OffsetDateTime> filterDraftStartedAtGte = Optional.empty();

        private Optional<SortOrderEnum> sortOrder = Optional.empty();

        private Optional<OrderExpandedListSortFieldEnum> sortBy = Optional.empty();

        private Optional<Integer> pageSize = Optional.empty();

        private Optional<Integer> page = Optional.empty();

        private Optional<List<OrderStatusEnum1>> filterStatuses = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ExpandedListPostShipperExpandedListV1Request other) {
            filterStatuses(other.getFilterStatuses());
            page(other.getPage());
            pageSize(other.getPageSize());
            sortBy(other.getSortBy());
            sortOrder(other.getSortOrder());
            filterDraftStartedAtGte(other.getFilterDraftStartedAtGte());
            filterDraftStartedAtLte(other.getFilterDraftStartedAtLte());
            filterOrderCancelled(other.getFilterOrderCancelled());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull OrderExpandedForShipperReq body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelled(Nullable<Boolean> filterOrderCancelled) {
            if (filterOrderCancelled.isNull()) {
                this.filterOrderCancelled = null;
            } else if (filterOrderCancelled.isEmpty()) {
                this.filterOrderCancelled = Optional.empty();
            } else {
                this.filterOrderCancelled = Optional.of(filterOrderCancelled.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterOrderCancelled(Boolean filterOrderCancelled) {
            this.filterOrderCancelled = Optional.ofNullable(filterOrderCancelled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_order_cancelled", nulls = Nulls.SKIP)
        public _FinalStage filterOrderCancelled(Optional<Boolean> filterOrderCancelled) {
            this.filterOrderCancelled = filterOrderCancelled;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtLte(Nullable<OffsetDateTime> filterDraftStartedAtLte) {
            if (filterDraftStartedAtLte.isNull()) {
                this.filterDraftStartedAtLte = null;
            } else if (filterDraftStartedAtLte.isEmpty()) {
                this.filterDraftStartedAtLte = Optional.empty();
            } else {
                this.filterDraftStartedAtLte = Optional.of(filterDraftStartedAtLte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtLte(OffsetDateTime filterDraftStartedAtLte) {
            this.filterDraftStartedAtLte = Optional.ofNullable(filterDraftStartedAtLte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_lte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtLte(Optional<OffsetDateTime> filterDraftStartedAtLte) {
            this.filterDraftStartedAtLte = filterDraftStartedAtLte;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtGte(Nullable<OffsetDateTime> filterDraftStartedAtGte) {
            if (filterDraftStartedAtGte.isNull()) {
                this.filterDraftStartedAtGte = null;
            } else if (filterDraftStartedAtGte.isEmpty()) {
                this.filterDraftStartedAtGte = Optional.empty();
            } else {
                this.filterDraftStartedAtGte = Optional.of(filterDraftStartedAtGte.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterDraftStartedAtGte(OffsetDateTime filterDraftStartedAtGte) {
            this.filterDraftStartedAtGte = Optional.ofNullable(filterDraftStartedAtGte);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_draft_started_at_gte", nulls = Nulls.SKIP)
        public _FinalStage filterDraftStartedAtGte(Optional<OffsetDateTime> filterDraftStartedAtGte) {
            this.filterDraftStartedAtGte = filterDraftStartedAtGte;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(Nullable<SortOrderEnum> sortOrder) {
            if (sortOrder.isNull()) {
                this.sortOrder = null;
            } else if (sortOrder.isEmpty()) {
                this.sortOrder = Optional.empty();
            } else {
                this.sortOrder = Optional.of(sortOrder.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortOrder(SortOrderEnum sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_order", nulls = Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrderEnum> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(Nullable<OrderExpandedListSortFieldEnum> sortBy) {
            if (sortBy.isNull()) {
                this.sortBy = null;
            } else if (sortBy.isEmpty()) {
                this.sortBy = Optional.empty();
            } else {
                this.sortBy = Optional.of(sortBy.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage sortBy(OrderExpandedListSortFieldEnum sortBy) {
            this.sortBy = Optional.ofNullable(sortBy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sort_by", nulls = Nulls.SKIP)
        public _FinalStage sortBy(Optional<OrderExpandedListSortFieldEnum> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Nullable<Integer> pageSize) {
            if (pageSize.isNull()) {
                this.pageSize = null;
            } else if (pageSize.isEmpty()) {
                this.pageSize = Optional.empty();
            } else {
                this.pageSize = Optional.of(pageSize.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage pageSize(Integer pageSize) {
            this.pageSize = Optional.ofNullable(pageSize);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page_size", nulls = Nulls.SKIP)
        public _FinalStage pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Nullable<Integer> page) {
            if (page.isNull()) {
                this.page = null;
            } else if (page.isEmpty()) {
                this.page = Optional.empty();
            } else {
                this.page = Optional.of(page.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "page", nulls = Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(OrderStatusEnum1 filterStatuses) {
            this.filterStatuses = Optional.of(Collections.singletonList(filterStatuses));
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(Nullable<List<OrderStatusEnum1>> filterStatuses) {
            if (filterStatuses.isNull()) {
                this.filterStatuses = null;
            } else if (filterStatuses.isEmpty()) {
                this.filterStatuses = Optional.empty();
            } else {
                this.filterStatuses = Optional.of(filterStatuses.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage filterStatuses(List<OrderStatusEnum1> filterStatuses) {
            this.filterStatuses = Optional.ofNullable(filterStatuses);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_statuses", nulls = Nulls.SKIP)
        public _FinalStage filterStatuses(Optional<List<OrderStatusEnum1>> filterStatuses) {
            this.filterStatuses = filterStatuses;
            return this;
        }

        @java.lang.Override
        public ExpandedListPostShipperExpandedListV1Request build() {
            return new ExpandedListPostShipperExpandedListV1Request(
                    filterStatuses,
                    page,
                    pageSize,
                    sortBy,
                    sortOrder,
                    filterDraftStartedAtGte,
                    filterDraftStartedAtLte,
                    filterOrderCancelled,
                    body,
                    additionalProperties);
        }
    }
}
