/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgconnectioninfos.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgconnectioninfos.courier.requests.CourierOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orgconnectioninfos.courier.requests.CourierOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.CourierOrgInfoForConnections1;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCourierClient rawClient;

    public AsyncCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCourierClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves courier organization connection information for the authenticated organization. | () -&gt; (CourierOrgInfoForConnections1)
     */
    public CompletableFuture<CourierOrgInfoForConnections1> getV1() {
        return this.rawClient.getV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves courier organization connection information for the authenticated organization. | () -&gt; (CourierOrgInfoForConnections1)
     */
    public CompletableFuture<CourierOrgInfoForConnections1> getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates courier organization connection information. Fails if already exists. | (CourierOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(CourierOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates courier organization connection information. Fails if already exists. | (CourierOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createV1(
            CourierOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1() {
        return this.rawClient.updateV1().thenApply(response -> response.body());
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(CourierOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateV1(
            CourierOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).thenApply(response -> response.body());
    }
}
