/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgconnectioninfos.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgconnectioninfos.courier.requests.CourierOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orgconnectioninfos.courier.requests.CourierOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.CourierOrgInfoForConnections1;

public class CourierClient {
    protected final ClientOptions clientOptions;

    private final RawCourierClient rawClient;

    public CourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCourierClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCourierClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves courier organization connection information for the authenticated organization. | () -&gt; (CourierOrgInfoForConnections1)
     */
    public CourierOrgInfoForConnections1 getV1() {
        return this.rawClient.getV1().body();
    }

    /**
     * Retrieves courier organization connection information for the authenticated organization. | () -&gt; (CourierOrgInfoForConnections1)
     */
    public CourierOrgInfoForConnections1 getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).body();
    }

    /**
     * Creates courier organization connection information. Fails if already exists. | (CourierOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(CourierOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates courier organization connection information. Fails if already exists. | (CourierOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(CourierOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1() {
        return this.rawClient.updateV1().body();
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(CourierOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates existing courier organization connection information. | (CourierOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(CourierOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }
}
