/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgconnectioninfos.shipper;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgconnectioninfos.shipper.requests.ShipperOrgInfoForConnectionsClientCreate1;
import com.chrt.api.resources.orgconnectioninfos.shipper.requests.ShipperOrgInfoForConnectionsClientUpdate1;
import com.chrt.api.types.ShipperOrgInfoForConnections1;

public class ShipperClient {
    protected final ClientOptions clientOptions;

    private final RawShipperClient rawClient;

    public ShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves shipper organization connection information for the authenticated organization. | () -&gt; (ShipperOrgInfoForConnections1)
     */
    public ShipperOrgInfoForConnections1 getV1() {
        return this.rawClient.getV1().body();
    }

    /**
     * Retrieves shipper organization connection information for the authenticated organization. | () -&gt; (ShipperOrgInfoForConnections1)
     */
    public ShipperOrgInfoForConnections1 getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).body();
    }

    /**
     * Creates shipper organization connection information. Fails if already exists. | (ShipperOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperOrgInfoForConnectionsClientCreate1 request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates shipper organization connection information. Fails if already exists. | (ShipperOrgInfoForConnectionsClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createV1(ShipperOrgInfoForConnectionsClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1() {
        return this.rawClient.updateV1().body();
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(ShipperOrgInfoForConnectionsClientUpdate1 request) {
        return this.rawClient.updateV1(request).body();
    }

    /**
     * Updates existing shipper organization connection information. | (ShipperOrgInfoForConnectionsClientUpdate1) -&gt; (bool)
     */
    public boolean updateV1(ShipperOrgInfoForConnectionsClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateV1(request, requestOptions).body();
    }
}
