/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgprofiles;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.CourierOrgProfileClientUpdate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientCreate1;
import com.chrt.api.resources.orgprofiles.requests.ForwarderOrgProfileClientUpdate1;
import com.chrt.api.types.OrgProfileRes1;

public class OrgProfilesClient {
    protected final ClientOptions clientOptions;

    private final RawOrgProfilesClient rawClient;

    public OrgProfilesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrgProfilesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawOrgProfilesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the courier or forwarder organization profile for the authenticated organization. | () -&gt; (OrgProfileRes1)
     */
    public OrgProfileRes1 getV1() {
        return this.rawClient.getV1().body();
    }

    /**
     * Retrieves the courier or forwarder organization profile for the authenticated organization. | () -&gt; (OrgProfileRes1)
     */
    public OrgProfileRes1 getV1(RequestOptions requestOptions) {
        return this.rawClient.getV1(requestOptions).body();
    }

    /**
     * Creates a new courier organization profile. Fails if a profile already exists for the organization. | (CourierOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createCourierV1(CourierOrgProfileClientCreate1 request) {
        return this.rawClient.createCourierV1(request).body();
    }

    /**
     * Creates a new courier organization profile. Fails if a profile already exists for the organization. | (CourierOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createCourierV1(CourierOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createCourierV1(request, requestOptions).body();
    }

    /**
     * Creates a new forwarder organization profile. Fails if a profile already exists for the organization. | (ForwarderOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createForwarderV1(ForwarderOrgProfileClientCreate1 request) {
        return this.rawClient.createForwarderV1(request).body();
    }

    /**
     * Creates a new forwarder organization profile. Fails if a profile already exists for the organization. | (ForwarderOrgProfileClientCreate1) -&gt; (PydanticObjectId)
     */
    public String createForwarderV1(ForwarderOrgProfileClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createForwarderV1(request, requestOptions).body();
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateCourierV1() {
        return this.rawClient.updateCourierV1().body();
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateCourierV1(CourierOrgProfileClientUpdate1 request) {
        return this.rawClient.updateCourierV1(request).body();
    }

    /**
     * Updates an existing courier organization profile. Can update one or more fields. | (CourierOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateCourierV1(CourierOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateCourierV1(request, requestOptions).body();
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateForwarderV1() {
        return this.rawClient.updateForwarderV1().body();
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateForwarderV1(ForwarderOrgProfileClientUpdate1 request) {
        return this.rawClient.updateForwarderV1(request).body();
    }

    /**
     * Updates an existing forwarder organization profile. Can update one or more fields. | (ForwarderOrgProfileClientUpdate1) -&gt; (bool)
     */
    public boolean updateForwarderV1(ForwarderOrgProfileClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient.updateForwarderV1(request, requestOptions).body();
    }

    /**
     * Retrieves a courier or forwarder organization profile using the organization's handle for public profile viewing. | () -&gt; (OrgProfileRes1)
     */
    public OrgProfileRes1 getByHandleV1(String handle) {
        return this.rawClient.getByHandleV1(handle).body();
    }

    /**
     * Retrieves a courier or forwarder organization profile using the organization's handle for public profile viewing. | () -&gt; (OrgProfileRes1)
     */
    public OrgProfileRes1 getByHandleV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getByHandleV1(handle, requestOptions).body();
    }

    /**
     * Returns the organization avatar image URL from Clerk or a placeholder if not found. | () -&gt; (str)
     */
    public String getAvatarV1(String handle) {
        return this.rawClient.getAvatarV1(handle).body();
    }

    /**
     * Returns the organization avatar image URL from Clerk or a placeholder if not found. | () -&gt; (str)
     */
    public String getAvatarV1(String handle, RequestOptions requestOptions) {
        return this.rawClient.getAvatarV1(handle, requestOptions).body();
    }
}
