/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgs;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgs.requests.CreateOrgPublicDataReq;
import com.chrt.api.resources.orgs.requests.UpdateOrgPublicDataReq;
import com.chrt.api.types.OrgMemberDetails;
import com.chrt.api.types.OrgPublicData1;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncOrgsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawOrgsClient rawClient;

    public AsyncOrgsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawOrgsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawOrgsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves basic organization information from the authentication service. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> getInfoV1() {
        return this.rawClient.getInfoV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves basic organization information from the authentication service. | () -&gt; (dict)
     */
    public CompletableFuture<Map<String, Object>> getInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getInfoV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all members of the authenticated organization with their roles and details. | () -&gt; (list[OrgMemberDetails])
     */
    public CompletableFuture<List<OrgMemberDetails>> listMembersV1() {
        return this.rawClient.listMembersV1().thenApply(response -> response.body());
    }

    /**
     * Lists all members of the authenticated organization with their roles and details. | () -&gt; (list[OrgMemberDetails])
     */
    public CompletableFuture<List<OrgMemberDetails>> listMembersV1(RequestOptions requestOptions) {
        return this.rawClient.listMembersV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves public organization data for the authenticated organization. | () -&gt; (OrgPublicData1)
     */
    public CompletableFuture<OrgPublicData1> getOrgPublicDataV1() {
        return this.rawClient.getOrgPublicDataV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves public organization data for the authenticated organization. | () -&gt; (OrgPublicData1)
     */
    public CompletableFuture<OrgPublicData1> getOrgPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates an org_public_data document for the authenticated organization. | (CreateOrgPublicDataReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOrgPublicDataV1(CreateOrgPublicDataReq request) {
        return this.rawClient.createOrgPublicDataV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates an org_public_data document for the authenticated organization. | (CreateOrgPublicDataReq) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> createOrgPublicDataV1(
            CreateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.createOrgPublicDataV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateOrgPublicDataV1() {
        return this.rawClient.updateOrgPublicDataV1().thenApply(response -> response.body());
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateOrgPublicDataV1(UpdateOrgPublicDataReq request) {
        return this.rawClient.updateOrgPublicDataV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public CompletableFuture<Boolean> updateOrgPublicDataV1(
            UpdateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.updateOrgPublicDataV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves public organization data for a specific organization by ID. | () -&gt; (OrgPublicData1)
     */
    public CompletableFuture<OrgPublicData1> getOrgPublicDataByOrgIdV1(String orgId) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId).thenApply(response -> response.body());
    }

    /**
     * Retrieves public organization data for a specific organization by ID. | () -&gt; (OrgPublicData1)
     */
    public CompletableFuture<OrgPublicData1> getOrgPublicDataByOrgIdV1(String orgId, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Returns True when the provided handle is available, otherwise False. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> getOrgPublicDataHandleAvailabilityV1(String handle) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle).thenApply(response -> response.body());
    }

    /**
     * Returns True when the provided handle is available, otherwise False. | () -&gt; (bool)
     */
    public CompletableFuture<Boolean> getOrgPublicDataHandleAvailabilityV1(
            String handle, RequestOptions requestOptions) {
        return this.rawClient
                .getOrgPublicDataHandleAvailabilityV1(handle, requestOptions)
                .thenApply(response -> response.body());
    }
}
