/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgs;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.orgs.requests.CreateOrgPublicDataReq;
import com.chrt.api.resources.orgs.requests.UpdateOrgPublicDataReq;
import com.chrt.api.types.OrgMemberDetails;
import com.chrt.api.types.OrgPublicData1;
import java.util.List;
import java.util.Map;

public class OrgsClient {
    protected final ClientOptions clientOptions;

    private final RawOrgsClient rawClient;

    public OrgsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOrgsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawOrgsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves basic organization information from the authentication service. | () -&gt; (dict)
     */
    public Map<String, Object> getInfoV1() {
        return this.rawClient.getInfoV1().body();
    }

    /**
     * Retrieves basic organization information from the authentication service. | () -&gt; (dict)
     */
    public Map<String, Object> getInfoV1(RequestOptions requestOptions) {
        return this.rawClient.getInfoV1(requestOptions).body();
    }

    /**
     * Lists all members of the authenticated organization with their roles and details. | () -&gt; (list[OrgMemberDetails])
     */
    public List<OrgMemberDetails> listMembersV1() {
        return this.rawClient.listMembersV1().body();
    }

    /**
     * Lists all members of the authenticated organization with their roles and details. | () -&gt; (list[OrgMemberDetails])
     */
    public List<OrgMemberDetails> listMembersV1(RequestOptions requestOptions) {
        return this.rawClient.listMembersV1(requestOptions).body();
    }

    /**
     * Retrieves public organization data for the authenticated organization. | () -&gt; (OrgPublicData1)
     */
    public OrgPublicData1 getOrgPublicDataV1() {
        return this.rawClient.getOrgPublicDataV1().body();
    }

    /**
     * Retrieves public organization data for the authenticated organization. | () -&gt; (OrgPublicData1)
     */
    public OrgPublicData1 getOrgPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataV1(requestOptions).body();
    }

    /**
     * Creates an org_public_data document for the authenticated organization. | (CreateOrgPublicDataReq) -&gt; (PydanticObjectId)
     */
    public String createOrgPublicDataV1(CreateOrgPublicDataReq request) {
        return this.rawClient.createOrgPublicDataV1(request).body();
    }

    /**
     * Creates an org_public_data document for the authenticated organization. | (CreateOrgPublicDataReq) -&gt; (PydanticObjectId)
     */
    public String createOrgPublicDataV1(CreateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.createOrgPublicDataV1(request, requestOptions).body();
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public boolean updateOrgPublicDataV1() {
        return this.rawClient.updateOrgPublicDataV1().body();
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public boolean updateOrgPublicDataV1(UpdateOrgPublicDataReq request) {
        return this.rawClient.updateOrgPublicDataV1(request).body();
    }

    /**
     * Updates the handle and/or company_name for the authenticated organization. | (UpdateOrgPublicDataReq) -&gt; (bool)
     */
    public boolean updateOrgPublicDataV1(UpdateOrgPublicDataReq request, RequestOptions requestOptions) {
        return this.rawClient.updateOrgPublicDataV1(request, requestOptions).body();
    }

    /**
     * Retrieves public organization data for a specific organization by ID. | () -&gt; (OrgPublicData1)
     */
    public OrgPublicData1 getOrgPublicDataByOrgIdV1(String orgId) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId).body();
    }

    /**
     * Retrieves public organization data for a specific organization by ID. | () -&gt; (OrgPublicData1)
     */
    public OrgPublicData1 getOrgPublicDataByOrgIdV1(String orgId, RequestOptions requestOptions) {
        return this.rawClient.getOrgPublicDataByOrgIdV1(orgId, requestOptions).body();
    }

    /**
     * Returns True when the provided handle is available, otherwise False. | () -&gt; (bool)
     */
    public boolean getOrgPublicDataHandleAvailabilityV1(String handle) {
        return this.rawClient.getOrgPublicDataHandleAvailabilityV1(handle).body();
    }

    /**
     * Returns True when the provided handle is available, otherwise False. | () -&gt; (bool)
     */
    public boolean getOrgPublicDataHandleAvailabilityV1(String handle, RequestOptions requestOptions) {
        return this.rawClient
                .getOrgPublicDataHandleAvailabilityV1(handle, requestOptions)
                .body();
    }
}
