/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgs.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrgTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateOrgPublicDataReq.Builder.class)
public final class CreateOrgPublicDataReq {
    private final OrgTypeEnum orgType;

    private final Optional<String> handle;

    private final Optional<String> companyName;

    private final Map<String, Object> additionalProperties;

    private CreateOrgPublicDataReq(
            OrgTypeEnum orgType,
            Optional<String> handle,
            Optional<String> companyName,
            Map<String, Object> additionalProperties) {
        this.orgType = orgType;
        this.handle = handle;
        this.companyName = companyName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("org_type")
    public OrgTypeEnum getOrgType() {
        return orgType;
    }

    @JsonIgnore
    public Optional<String> getHandle() {
        if (handle == null) {
            return Optional.empty();
        }
        return handle;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (companyName == null) {
            return Optional.empty();
        }
        return companyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("handle")
    private Optional<String> _getHandle() {
        return handle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("company_name")
    private Optional<String> _getCompanyName() {
        return companyName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateOrgPublicDataReq && equalTo((CreateOrgPublicDataReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrgPublicDataReq other) {
        return orgType.equals(other.orgType) && handle.equals(other.handle) && companyName.equals(other.companyName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.orgType, this.handle, this.companyName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrgTypeStage builder() {
        return new Builder();
    }

    public interface OrgTypeStage {
        _FinalStage orgType(@NotNull OrgTypeEnum orgType);

        Builder from(CreateOrgPublicDataReq other);
    }

    public interface _FinalStage {
        CreateOrgPublicDataReq build();

        _FinalStage handle(Optional<String> handle);

        _FinalStage handle(String handle);

        _FinalStage handle(Nullable<String> handle);

        _FinalStage companyName(Optional<String> companyName);

        _FinalStage companyName(String companyName);

        _FinalStage companyName(Nullable<String> companyName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OrgTypeStage, _FinalStage {
        private OrgTypeEnum orgType;

        private Optional<String> companyName = Optional.empty();

        private Optional<String> handle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateOrgPublicDataReq other) {
            orgType(other.getOrgType());
            handle(other.getHandle());
            companyName(other.getCompanyName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("org_type")
        public _FinalStage orgType(@NotNull OrgTypeEnum orgType) {
            this.orgType = Objects.requireNonNull(orgType, "orgType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(Nullable<String> companyName) {
            if (companyName.isNull()) {
                this.companyName = null;
            } else if (companyName.isEmpty()) {
                this.companyName = Optional.empty();
            } else {
                this.companyName = Optional.of(companyName.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_name", nulls = Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @java.lang.Override
        public _FinalStage handle(Nullable<String> handle) {
            if (handle.isNull()) {
                this.handle = null;
            } else if (handle.isEmpty()) {
                this.handle = Optional.empty();
            } else {
                this.handle = Optional.of(handle.get());
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage handle(String handle) {
            this.handle = Optional.ofNullable(handle);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "handle", nulls = Nulls.SKIP)
        public _FinalStage handle(Optional<String> handle) {
            this.handle = handle;
            return this;
        }

        @java.lang.Override
        public CreateOrgPublicDataReq build() {
            return new CreateOrgPublicDataReq(orgType, handle, companyName, additionalProperties);
        }
    }
}
