/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.orgs.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateOrgPublicDataReq.Builder.class)
public final class UpdateOrgPublicDataReq {
    private final Optional<String> handle;

    private final Optional<String> companyName;

    private final Map<String, Object> additionalProperties;

    private UpdateOrgPublicDataReq(
            Optional<String> handle, Optional<String> companyName, Map<String, Object> additionalProperties) {
        this.handle = handle;
        this.companyName = companyName;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getHandle() {
        if (handle == null) {
            return Optional.empty();
        }
        return handle;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (companyName == null) {
            return Optional.empty();
        }
        return companyName;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("handle")
    private Optional<String> _getHandle() {
        return handle;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("company_name")
    private Optional<String> _getCompanyName() {
        return companyName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateOrgPublicDataReq && equalTo((UpdateOrgPublicDataReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateOrgPublicDataReq other) {
        return handle.equals(other.handle) && companyName.equals(other.companyName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.handle, this.companyName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> handle = Optional.empty();

        private Optional<String> companyName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UpdateOrgPublicDataReq other) {
            handle(other.getHandle());
            companyName(other.getCompanyName());
            return this;
        }

        @JsonSetter(value = "handle", nulls = Nulls.SKIP)
        public Builder handle(Optional<String> handle) {
            this.handle = handle;
            return this;
        }

        public Builder handle(String handle) {
            this.handle = Optional.ofNullable(handle);
            return this;
        }

        public Builder handle(Nullable<String> handle) {
            if (handle.isNull()) {
                this.handle = null;
            } else if (handle.isEmpty()) {
                this.handle = Optional.empty();
            } else {
                this.handle = Optional.of(handle.get());
            }
            return this;
        }

        @JsonSetter(value = "company_name", nulls = Nulls.SKIP)
        public Builder companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        public Builder companyName(Nullable<String> companyName) {
            if (companyName.isNull()) {
                this.companyName = null;
            } else if (companyName.isEmpty()) {
                this.companyName = Optional.empty();
            } else {
                this.companyName = Optional.of(companyName.get());
            }
            return this;
        }

        public UpdateOrgPublicDataReq build() {
            return new UpdateOrgPublicDataReq(handle, companyName, additionalProperties);
        }
    }
}
