/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.resources.payments.requests.GenerateInvoiceReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import com.chrt.api.types.CreateConnectAccountLinkRes;
import com.chrt.api.types.CreateConnectAccountRes;
import com.chrt.api.types.GenerateInvoiceRes;
import java.util.concurrent.CompletableFuture;

public class AsyncPaymentsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawPaymentsClient rawClient;

    public AsyncPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Generates and sends a Stripe invoice for a shipper statement to a courier organization's Connect account. Applies a 10% application fee.
     */
    public CompletableFuture<GenerateInvoiceRes> generateInvoiceV1(GenerateInvoiceReq request) {
        return this.rawClient.generateInvoiceV1(request).thenApply(response -> response.body());
    }

    /**
     * Generates and sends a Stripe invoice for a shipper statement to a courier organization's Connect account. Applies a 10% application fee.
     */
    public CompletableFuture<GenerateInvoiceRes> generateInvoiceV1(
            GenerateInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient.generateInvoiceV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan.
     */
    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan.
     */
    public CompletableFuture<CreateCheckoutSessionRes> createCheckoutSessionV1(
            CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user.
     */
    public CompletableFuture<Boolean> syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().thenApply(response -> response.body());
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user.
     */
    public CompletableFuture<Boolean> syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created.
     */
    public CompletableFuture<CreateConnectAccountRes> createConnectAccountV1() {
        return this.rawClient.createConnectAccountV1().thenApply(response -> response.body());
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created.
     */
    public CompletableFuture<CreateConnectAccountRes> createConnectAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup.
     */
    public CompletableFuture<CreateConnectAccountLinkRes> createConnectAccountLinkV1() {
        return this.rawClient.createConnectAccountLinkV1().thenApply(response -> response.body());
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup.
     */
    public CompletableFuture<CreateConnectAccountLinkRes> createConnectAccountLinkV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountLinkV1(requestOptions).thenApply(response -> response.body());
    }
}
