/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.payments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.payments.requests.CreateCheckoutSessionReq;
import com.chrt.api.resources.payments.requests.GenerateInvoiceReq;
import com.chrt.api.types.CreateCheckoutSessionRes;
import com.chrt.api.types.CreateConnectAccountLinkRes;
import com.chrt.api.types.CreateConnectAccountRes;
import com.chrt.api.types.GenerateInvoiceRes;

public class PaymentsClient {
    protected final ClientOptions clientOptions;

    private final RawPaymentsClient rawClient;

    public PaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Generates and sends a Stripe invoice for a shipper statement to a courier organization's Connect account. Applies a 10% application fee.
     */
    public GenerateInvoiceRes generateInvoiceV1(GenerateInvoiceReq request) {
        return this.rawClient.generateInvoiceV1(request).body();
    }

    /**
     * Generates and sends a Stripe invoice for a shipper statement to a courier organization's Connect account. Applies a 10% application fee.
     */
    public GenerateInvoiceRes generateInvoiceV1(GenerateInvoiceReq request, RequestOptions requestOptions) {
        return this.rawClient.generateInvoiceV1(request, requestOptions).body();
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan.
     */
    public CreateCheckoutSessionRes createCheckoutSessionV1(CreateCheckoutSessionReq request) {
        return this.rawClient.createCheckoutSessionV1(request).body();
    }

    /**
     * Creates a Stripe checkout session for a subscription with pricing based on the selected plan.
     */
    public CreateCheckoutSessionRes createCheckoutSessionV1(
            CreateCheckoutSessionReq request, RequestOptions requestOptions) {
        return this.rawClient.createCheckoutSessionV1(request, requestOptions).body();
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user.
     */
    public boolean syncStripeToClerkV1() {
        return this.rawClient.syncStripeToClerkV1().body();
    }

    /**
     * Synchronizes subscription data from Stripe to the authentication service for the current user.
     */
    public boolean syncStripeToClerkV1(RequestOptions requestOptions) {
        return this.rawClient.syncStripeToClerkV1(requestOptions).body();
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created.
     */
    public CreateConnectAccountRes createConnectAccountV1() {
        return this.rawClient.createConnectAccountV1().body();
    }

    /**
     * Creates a Stripe Connect account for the organization to receive payments. Idempotent - returns existing account if already created.
     */
    public CreateConnectAccountRes createConnectAccountV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountV1(requestOptions).body();
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup.
     */
    public CreateConnectAccountLinkRes createConnectAccountLinkV1() {
        return this.rawClient.createConnectAccountLinkV1().body();
    }

    /**
     * Creates an onboarding link for a Stripe Connect account. Used to complete or update account setup.
     */
    public CreateConnectAccountLinkRes createConnectAccountLinkV1(RequestOptions requestOptions) {
        return this.rawClient.createConnectAccountLinkV1(requestOptions).body();
    }
}
