/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.payments.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GenerateInvoiceReq.Builder.class)
public final class GenerateInvoiceReq {
    private final String shipperPayCourierStatementId;

    private final Optional<Integer> daysUntilDue;

    private final Optional<String> description;

    private final Map<String, Object> additionalProperties;

    private GenerateInvoiceReq(
            String shipperPayCourierStatementId,
            Optional<Integer> daysUntilDue,
            Optional<String> description,
            Map<String, Object> additionalProperties) {
        this.shipperPayCourierStatementId = shipperPayCourierStatementId;
        this.daysUntilDue = daysUntilDue;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("shipper_pay_courier_statement_id")
    public String getShipperPayCourierStatementId() {
        return shipperPayCourierStatementId;
    }

    @JsonProperty("days_until_due")
    public Optional<Integer> getDaysUntilDue() {
        return daysUntilDue;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GenerateInvoiceReq && equalTo((GenerateInvoiceReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateInvoiceReq other) {
        return shipperPayCourierStatementId.equals(other.shipperPayCourierStatementId)
                && daysUntilDue.equals(other.daysUntilDue)
                && description.equals(other.description);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.shipperPayCourierStatementId, this.daysUntilDue, this.description);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ShipperPayCourierStatementIdStage builder() {
        return new Builder();
    }

    public interface ShipperPayCourierStatementIdStage {
        _FinalStage shipperPayCourierStatementId(@NotNull String shipperPayCourierStatementId);

        Builder from(GenerateInvoiceReq other);
    }

    public interface _FinalStage {
        GenerateInvoiceReq build();

        _FinalStage daysUntilDue(Optional<Integer> daysUntilDue);

        _FinalStage daysUntilDue(Integer daysUntilDue);

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ShipperPayCourierStatementIdStage, _FinalStage {
        private String shipperPayCourierStatementId;

        private Optional<String> description = Optional.empty();

        private Optional<Integer> daysUntilDue = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GenerateInvoiceReq other) {
            shipperPayCourierStatementId(other.getShipperPayCourierStatementId());
            daysUntilDue(other.getDaysUntilDue());
            description(other.getDescription());
            return this;
        }

        @java.lang.Override
        @JsonSetter("shipper_pay_courier_statement_id")
        public _FinalStage shipperPayCourierStatementId(@NotNull String shipperPayCourierStatementId) {
            this.shipperPayCourierStatementId = Objects.requireNonNull(
                    shipperPayCourierStatementId, "shipperPayCourierStatementId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public _FinalStage daysUntilDue(Integer daysUntilDue) {
            this.daysUntilDue = Optional.ofNullable(daysUntilDue);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "days_until_due", nulls = Nulls.SKIP)
        public _FinalStage daysUntilDue(Optional<Integer> daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        @java.lang.Override
        public GenerateInvoiceReq build() {
            return new GenerateInvoiceReq(
                    shipperPayCourierStatementId, daysUntilDue, description, additionalProperties);
        }
    }
}
