/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperContactInfoClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperContactInfoClient rawClient;

    public AsyncShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperContactInfoClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the authenticated user's own shipper contact information.
     */
    public CompletableFuture<ShipperContact1> getByJwtUserIdV1() {
        return this.rawClient.getByJwtUserIdV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves the authenticated user's own shipper contact information.
     */
    public CompletableFuture<ShipperContact1> getByJwtUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getByJwtUserIdV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts created by the authenticated organization.
     */
    public CompletableFuture<List<ShipperContact1>> listByJwtOrgIdV1() {
        return this.rawClient.listByJwtOrgIdV1().thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts created by the authenticated organization.
     */
    public CompletableFuture<List<ShipperContact1>> listByJwtOrgIdV1(RequestOptions requestOptions) {
        return this.rawClient.listByJwtOrgIdV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper.
     */
    public CompletableFuture<List<ShipperContact1>> listCourierContactsByShipperOrgIdV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsByShipperOrgIdV1(shipperOrgId).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper.
     */
    public CompletableFuture<List<ShipperContact1>> listCourierContactsByShipperOrgIdV1(
            String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listCourierContactsByShipperOrgIdV1(shipperOrgId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper connection.
     */
    public CompletableFuture<List<ShipperContact1>> listByOffChrtShipperOrgIdV1(String offChrtShipperOrgId) {
        return this.rawClient.listByOffChrtShipperOrgIdV1(offChrtShipperOrgId).thenApply(response -> response.body());
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper connection.
     */
    public CompletableFuture<List<ShipperContact1>> listByOffChrtShipperOrgIdV1(
            String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listByOffChrtShipperOrgIdV1(offChrtShipperOrgId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it.
     */
    public CompletableFuture<ShipperContact1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it.
     */
    public CompletableFuture<ShipperContact1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an on-platform shipper organization or user.
     */
    public CompletableFuture<String> createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an on-platform shipper organization or user.
     */
    public CompletableFuture<String> createOnPlatformV1(
            ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an off-platform shipper using connection info.
     */
    public CompletableFuture<String> createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates contact information for an off-platform shipper using connection info.
     */
    public CompletableFuture<String> createOffPlatformV1(
            ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).thenApply(response -> response.body());
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> updateV1(
            String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient
                .updateV1(shipperContactInfoId, request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Deletes shipper contact information owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Deletes shipper contact information owned by the authenticated organization.
     */
    public CompletableFuture<Boolean> deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).thenApply(response -> response.body());
    }
}
