/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shippercontactinfo;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shippercontactinfo.requests.ShipperContactClientUpdate1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.ShipperContactClientCreate1;
import java.util.List;

public class ShipperContactInfoClient {
    protected final ClientOptions clientOptions;

    private final RawShipperContactInfoClient rawClient;

    public ShipperContactInfoClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperContactInfoClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperContactInfoClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the authenticated user's own shipper contact information.
     */
    public ShipperContact1 getByJwtUserIdV1() {
        return this.rawClient.getByJwtUserIdV1().body();
    }

    /**
     * Retrieves the authenticated user's own shipper contact information.
     */
    public ShipperContact1 getByJwtUserIdV1(RequestOptions requestOptions) {
        return this.rawClient.getByJwtUserIdV1(requestOptions).body();
    }

    /**
     * Lists all shipper contacts created by the authenticated organization.
     */
    public List<ShipperContact1> listByJwtOrgIdV1() {
        return this.rawClient.listByJwtOrgIdV1().body();
    }

    /**
     * Lists all shipper contacts created by the authenticated organization.
     */
    public List<ShipperContact1> listByJwtOrgIdV1(RequestOptions requestOptions) {
        return this.rawClient.listByJwtOrgIdV1(requestOptions).body();
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper.
     */
    public List<ShipperContact1> listCourierContactsByShipperOrgIdV1(String shipperOrgId) {
        return this.rawClient.listCourierContactsByShipperOrgIdV1(shipperOrgId).body();
    }

    /**
     * Lists all shipper contacts accessible to the courier organization for a specific on-platform shipper.
     */
    public List<ShipperContact1> listCourierContactsByShipperOrgIdV1(
            String shipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listCourierContactsByShipperOrgIdV1(shipperOrgId, requestOptions)
                .body();
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper connection.
     */
    public List<ShipperContact1> listByOffChrtShipperOrgIdV1(String offChrtShipperOrgId) {
        return this.rawClient.listByOffChrtShipperOrgIdV1(offChrtShipperOrgId).body();
    }

    /**
     * Lists all shipper contacts for a specific off-platform shipper connection.
     */
    public List<ShipperContact1> listByOffChrtShipperOrgIdV1(
            String offChrtShipperOrgId, RequestOptions requestOptions) {
        return this.rawClient
                .listByOffChrtShipperOrgIdV1(offChrtShipperOrgId, requestOptions)
                .body();
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it.
     */
    public ShipperContact1 getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).body();
    }

    /**
     * Retrieves a specific shipper contact by ID if authorized to access it.
     */
    public ShipperContact1 getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).body();
    }

    /**
     * Creates contact information for an on-platform shipper organization or user.
     */
    public String createOnPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOnPlatformV1(request).body();
    }

    /**
     * Creates contact information for an on-platform shipper organization or user.
     */
    public String createOnPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOnPlatformV1(request, requestOptions).body();
    }

    /**
     * Creates contact information for an off-platform shipper using connection info.
     */
    public String createOffPlatformV1(ShipperContactClientCreate1 request) {
        return this.rawClient.createOffPlatformV1(request).body();
    }

    /**
     * Creates contact information for an off-platform shipper using connection info.
     */
    public String createOffPlatformV1(ShipperContactClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.createOffPlatformV1(request, requestOptions).body();
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public boolean updateV1(String shipperContactInfoId) {
        return this.rawClient.updateV1(shipperContactInfoId).body();
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public boolean updateV1(String shipperContactInfoId, ShipperContactClientUpdate1 request) {
        return this.rawClient.updateV1(shipperContactInfoId, request).body();
    }

    /**
     * Updates existing shipper contact information owned by the authenticated organization.
     */
    public boolean updateV1(
            String shipperContactInfoId, ShipperContactClientUpdate1 request, RequestOptions requestOptions) {
        return this.rawClient
                .updateV1(shipperContactInfoId, request, requestOptions)
                .body();
    }

    /**
     * Deletes shipper contact information owned by the authenticated organization.
     */
    public boolean deleteByIdV1(String id) {
        return this.rawClient.deleteByIdV1(id).body();
    }

    /**
     * Deletes shipper contact information owned by the authenticated organization.
     */
    public boolean deleteByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteByIdV1(id, requestOptions).body();
    }
}
