/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups.courier;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncCourierClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawCourierClient rawClient;

    public AsyncCourierClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCourierClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawCourierClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all shipper pay courier line item groups for the authenticated courier organization.
     */
    public CompletableFuture<List<ShipperPayCourierLineItemGroup1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all shipper pay courier line item groups for the authenticated courier organization.
     */
    public CompletableFuture<List<ShipperPayCourierLineItemGroup1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }
}
