/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierlineitemgroups.shipper;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.types.ShipperPayCourierLineItemGroup1;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperClient rawClient;

    public AsyncShipperClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Lists all shipper pay courier line item groups for the authenticated shipper organization.
     */
    public CompletableFuture<List<ShipperPayCourierLineItemGroup1>> listV1() {
        return this.rawClient.listV1().thenApply(response -> response.body());
    }

    /**
     * Lists all shipper pay courier line item groups for the authenticated shipper organization.
     */
    public CompletableFuture<List<ShipperPayCourierLineItemGroup1>> listV1(RequestOptions requestOptions) {
        return this.rawClient.listV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the authenticated shipper organization.
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id) {
        return this.rawClient.getByIdV1(id).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its ID for the authenticated shipper organization.
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> getByIdV1(String id, RequestOptions requestOptions) {
        return this.rawClient.getByIdV1(id, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the authenticated shipper organization.
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(String taskGroupId) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier line item group by its associated task group ID for the authenticated shipper organization.
     */
    public CompletableFuture<ShipperPayCourierLineItemGroup1> byTaskGroupIdV1(
            String taskGroupId, RequestOptions requestOptions) {
        return this.rawClient.byTaskGroupIdV1(taskGroupId, requestOptions).thenApply(response -> response.body());
    }
}
