/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierpayments;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierpayments.requests.ListPaymentsByCourierReq;
import com.chrt.api.resources.shipperpaycourierpayments.requests.ListPaymentsByShipperReq;
import com.chrt.api.types.CreateShipperPayCourierPaymentReq;
import com.chrt.api.types.GetShipperPayCourierPaymentsForShipperRes;
import com.chrt.api.types.PaymentPreviewResponse;
import com.chrt.api.types.ShipperPayCourierStatement1;

public class ShipperPayCourierPaymentsClient {
    protected final ClientOptions clientOptions;

    private final RawShipperPayCourierPaymentsClient rawClient;

    public ShipperPayCourierPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperPayCourierPaymentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperPayCourierPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier payment by its ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByIdV1(String shipperPayCourierPaymentId) {
        return this.rawClient.getByIdV1(shipperPayCourierPaymentId).body();
    }

    /**
     * Retrieves a shipper pay courier payment by its ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByIdV1(String shipperPayCourierPaymentId, RequestOptions requestOptions) {
        return this.rawClient
                .getByIdV1(shipperPayCourierPaymentId, requestOptions)
                .body();
    }

    /**
     * Deletes a shipper-to-courier payment record if invoice not yet created.
     */
    public boolean deleteV1(String shipperPayCourierPaymentId) {
        return this.rawClient.deleteV1(shipperPayCourierPaymentId).body();
    }

    /**
     * Deletes a shipper-to-courier payment record if invoice not yet created.
     */
    public boolean deleteV1(String shipperPayCourierPaymentId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(shipperPayCourierPaymentId, requestOptions)
                .body();
    }

    /**
     * Retrieves a shipper pay courier payment by order ID or short ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByOrderIdOrShortIdV1(String orderIdOrShortId) {
        return this.rawClient.getByOrderIdOrShortIdV1(orderIdOrShortId).body();
    }

    /**
     * Retrieves a shipper pay courier payment by order ID or short ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByOrderIdOrShortIdV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .getByOrderIdOrShortIdV1(orderIdOrShortId, requestOptions)
                .body();
    }

    /**
     * Lists shipper pay courier payments by shipper org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierPaymentsForShipperRes listByShipperOrgIdV1(ListPaymentsByShipperReq request) {
        return this.rawClient.listByShipperOrgIdV1(request).body();
    }

    /**
     * Lists shipper pay courier payments by shipper org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierPaymentsForShipperRes listByShipperOrgIdV1(
            ListPaymentsByShipperReq request, RequestOptions requestOptions) {
        return this.rawClient.listByShipperOrgIdV1(request, requestOptions).body();
    }

    /**
     * Lists shipper pay courier payments by courier org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierPaymentsForShipperRes listByCourierOrgIdV1(ListPaymentsByCourierReq request) {
        return this.rawClient.listByCourierOrgIdV1(request).body();
    }

    /**
     * Lists shipper pay courier payments by courier org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierPaymentsForShipperRes listByCourierOrgIdV1(
            ListPaymentsByCourierReq request, RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(request, requestOptions).body();
    }

    /**
     * Creates a shipper-to-courier payment record based on all task groups in an order.
     */
    public String createV1(CreateShipperPayCourierPaymentReq request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a shipper-to-courier payment record based on all task groups in an order.
     */
    public String createV1(CreateShipperPayCourierPaymentReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Previews a shipper-to-courier payment showing task groups, line item groups, total amount, and readiness status.
     */
    public PaymentPreviewResponse previewV1(CreateShipperPayCourierPaymentReq request) {
        return this.rawClient.previewV1(request).body();
    }

    /**
     * Previews a shipper-to-courier payment showing task groups, line item groups, total amount, and readiness status.
     */
    public PaymentPreviewResponse previewV1(CreateShipperPayCourierPaymentReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).body();
    }
}
