/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierpayments.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.StripeConnectInvoiceStatusEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListPaymentsByCourierReq.Builder.class)
public final class ListPaymentsByCourierReq {
    private final List<StripeConnectInvoiceStatusEnum> statuses;

    private final Optional<String> shipperOrgId;

    private final Optional<String> offChrtShipperOrgId;

    private final Map<String, Object> additionalProperties;

    private ListPaymentsByCourierReq(
            List<StripeConnectInvoiceStatusEnum> statuses,
            Optional<String> shipperOrgId,
            Optional<String> offChrtShipperOrgId,
            Map<String, Object> additionalProperties) {
        this.statuses = statuses;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("statuses")
    public List<StripeConnectInvoiceStatusEnum> getStatuses() {
        return statuses;
    }

    /**
     * @return Must be a string starting with <code>org_</code>
     */
    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (shipperOrgId == null) {
            return Optional.empty();
        }
        return shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return offChrtShipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return shipperOrgId;
    }

    @JsonInclude(value = JsonInclude.Include.CUSTOM, valueFilter = NullableNonemptyFilter.class)
    @JsonProperty("off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return offChrtShipperOrgId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListPaymentsByCourierReq && equalTo((ListPaymentsByCourierReq) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPaymentsByCourierReq other) {
        return statuses.equals(other.statuses)
                && shipperOrgId.equals(other.shipperOrgId)
                && offChrtShipperOrgId.equals(other.offChrtShipperOrgId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.statuses, this.shipperOrgId, this.offChrtShipperOrgId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<StripeConnectInvoiceStatusEnum> statuses = new ArrayList<>();

        private Optional<String> shipperOrgId = Optional.empty();

        private Optional<String> offChrtShipperOrgId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListPaymentsByCourierReq other) {
            statuses(other.getStatuses());
            shipperOrgId(other.getShipperOrgId());
            offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            return this;
        }

        @JsonSetter(value = "statuses", nulls = Nulls.SKIP)
        public Builder statuses(List<StripeConnectInvoiceStatusEnum> statuses) {
            this.statuses.clear();
            if (statuses != null) {
                this.statuses.addAll(statuses);
            }
            return this;
        }

        public Builder addStatuses(StripeConnectInvoiceStatusEnum statuses) {
            this.statuses.add(statuses);
            return this;
        }

        public Builder addAllStatuses(List<StripeConnectInvoiceStatusEnum> statuses) {
            if (statuses != null) {
                this.statuses.addAll(statuses);
            }
            return this;
        }

        /**
         * <p>Must be a string starting with <code>org_</code></p>
         */
        @JsonSetter(value = "shipper_org_id", nulls = Nulls.SKIP)
        public Builder shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        public Builder shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        public Builder shipperOrgId(Nullable<String> shipperOrgId) {
            if (shipperOrgId.isNull()) {
                this.shipperOrgId = null;
            } else if (shipperOrgId.isEmpty()) {
                this.shipperOrgId = Optional.empty();
            } else {
                this.shipperOrgId = Optional.of(shipperOrgId.get());
            }
            return this;
        }

        @JsonSetter(value = "off_chrt_shipper_org_id", nulls = Nulls.SKIP)
        public Builder offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        public Builder offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        public Builder offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            if (offChrtShipperOrgId.isNull()) {
                this.offChrtShipperOrgId = null;
            } else if (offChrtShipperOrgId.isEmpty()) {
                this.offChrtShipperOrgId = Optional.empty();
            } else {
                this.offChrtShipperOrgId = Optional.of(offChrtShipperOrgId.get());
            }
            return this;
        }

        public ListPaymentsByCourierReq build() {
            return new ListPaymentsByCourierReq(statuses, shipperOrgId, offChrtShipperOrgId, additionalProperties);
        }
    }
}
