/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierstatements;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByCourierReq;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByShipperReq;
import com.chrt.api.types.CreateShipperPayCourierStatementReq;
import com.chrt.api.types.GetShipperPayCourierStatementsForShipperRes;
import com.chrt.api.types.ShipperPayCourierStatement1;
import com.chrt.api.types.StatementPreviewResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncShipperPayCourierStatementsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawShipperPayCourierStatementsClient rawClient;

    public AsyncShipperPayCourierStatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawShipperPayCourierStatementsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawShipperPayCourierStatementsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync.
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByIdV1(String shipperPayCourierStatementId) {
        return this.rawClient.getByIdV1(shipperPayCourierStatementId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync.
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByIdV1(
            String shipperPayCourierStatementId, RequestOptions requestOptions) {
        return this.rawClient
                .getByIdV1(shipperPayCourierStatementId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created.
     */
    public CompletableFuture<Boolean> deleteV1(String shipperPayCourierStatementId) {
        return this.rawClient.deleteV1(shipperPayCourierStatementId).thenApply(response -> response.body());
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created.
     */
    public CompletableFuture<Boolean> deleteV1(String shipperPayCourierStatementId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(shipperPayCourierStatementId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync.
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByOrderIdOrShortIdV1(String orderIdOrShortId) {
        return this.rawClient.getByOrderIdOrShortIdV1(orderIdOrShortId).thenApply(response -> response.body());
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync.
     */
    public CompletableFuture<ShipperPayCourierStatement1> getByOrderIdOrShortIdV1(
            String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .getByOrderIdOrShortIdV1(orderIdOrShortId, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync.
     */
    public CompletableFuture<GetShipperPayCourierStatementsForShipperRes> listByShipperOrgIdV1(
            ListStatementsByShipperReq request) {
        return this.rawClient.listByShipperOrgIdV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync.
     */
    public CompletableFuture<GetShipperPayCourierStatementsForShipperRes> listByShipperOrgIdV1(
            ListStatementsByShipperReq request, RequestOptions requestOptions) {
        return this.rawClient.listByShipperOrgIdV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync.
     */
    public CompletableFuture<GetShipperPayCourierStatementsForShipperRes> listByCourierOrgIdV1(
            ListStatementsByCourierReq request) {
        return this.rawClient.listByCourierOrgIdV1(request).thenApply(response -> response.body());
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync.
     */
    public CompletableFuture<GetShipperPayCourierStatementsForShipperRes> listByCourierOrgIdV1(
            ListStatementsByCourierReq request, RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order.
     */
    public CompletableFuture<String> createV1(CreateShipperPayCourierStatementReq request) {
        return this.rawClient.createV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order.
     */
    public CompletableFuture<String> createV1(
            CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status.
     */
    public CompletableFuture<StatementPreviewResponse> previewV1(CreateShipperPayCourierStatementReq request) {
        return this.rawClient.previewV1(request).thenApply(response -> response.body());
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status.
     */
    public CompletableFuture<StatementPreviewResponse> previewV1(
            CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).thenApply(response -> response.body());
    }
}
