/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.shipperpaycourierstatements;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByCourierReq;
import com.chrt.api.resources.shipperpaycourierstatements.requests.ListStatementsByShipperReq;
import com.chrt.api.types.CreateShipperPayCourierStatementReq;
import com.chrt.api.types.GetShipperPayCourierStatementsForShipperRes;
import com.chrt.api.types.ShipperPayCourierStatement1;
import com.chrt.api.types.StatementPreviewResponse;

public class ShipperPayCourierStatementsClient {
    protected final ClientOptions clientOptions;

    private final RawShipperPayCourierStatementsClient rawClient;

    public ShipperPayCourierStatementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawShipperPayCourierStatementsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawShipperPayCourierStatementsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByIdV1(String shipperPayCourierStatementId) {
        return this.rawClient.getByIdV1(shipperPayCourierStatementId).body();
    }

    /**
     * Retrieves a shipper pay courier statement by its ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByIdV1(String shipperPayCourierStatementId, RequestOptions requestOptions) {
        return this.rawClient
                .getByIdV1(shipperPayCourierStatementId, requestOptions)
                .body();
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created.
     */
    public boolean deleteV1(String shipperPayCourierStatementId) {
        return this.rawClient.deleteV1(shipperPayCourierStatementId).body();
    }

    /**
     * Deletes a shipper-to-courier statement record if invoice not yet created.
     */
    public boolean deleteV1(String shipperPayCourierStatementId, RequestOptions requestOptions) {
        return this.rawClient
                .deleteV1(shipperPayCourierStatementId, requestOptions)
                .body();
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByOrderIdOrShortIdV1(String orderIdOrShortId) {
        return this.rawClient.getByOrderIdOrShortIdV1(orderIdOrShortId).body();
    }

    /**
     * Retrieves a shipper pay courier statement by order ID or short ID with Stripe invoice sync.
     */
    public ShipperPayCourierStatement1 getByOrderIdOrShortIdV1(String orderIdOrShortId, RequestOptions requestOptions) {
        return this.rawClient
                .getByOrderIdOrShortIdV1(orderIdOrShortId, requestOptions)
                .body();
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierStatementsForShipperRes listByShipperOrgIdV1(ListStatementsByShipperReq request) {
        return this.rawClient.listByShipperOrgIdV1(request).body();
    }

    /**
     * Lists shipper pay courier statements by shipper org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierStatementsForShipperRes listByShipperOrgIdV1(
            ListStatementsByShipperReq request, RequestOptions requestOptions) {
        return this.rawClient.listByShipperOrgIdV1(request, requestOptions).body();
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierStatementsForShipperRes listByCourierOrgIdV1(ListStatementsByCourierReq request) {
        return this.rawClient.listByCourierOrgIdV1(request).body();
    }

    /**
     * Lists shipper pay courier statements by courier org ID with status filtering and Stripe sync.
     */
    public GetShipperPayCourierStatementsForShipperRes listByCourierOrgIdV1(
            ListStatementsByCourierReq request, RequestOptions requestOptions) {
        return this.rawClient.listByCourierOrgIdV1(request, requestOptions).body();
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order.
     */
    public String createV1(CreateShipperPayCourierStatementReq request) {
        return this.rawClient.createV1(request).body();
    }

    /**
     * Creates a shipper-to-courier statement record based on all task groups in an order.
     */
    public String createV1(CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.createV1(request, requestOptions).body();
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status.
     */
    public StatementPreviewResponse previewV1(CreateShipperPayCourierStatementReq request) {
        return this.rawClient.previewV1(request).body();
    }

    /**
     * Previews a shipper-to-courier statement showing task groups, line item groups, total amount, and readiness status.
     */
    public StatementPreviewResponse previewV1(
            CreateShipperPayCourierStatementReq request, RequestOptions requestOptions) {
        return this.rawClient.previewV1(request, requestOptions).body();
    }
}
