/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifactnotifications;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.taskartifactnotifications.requests.TaskArtifactNotificationPreferencesClientCreate1;
import com.chrt.api.types.TaskArtifactNotificationPreferences1;
import java.util.concurrent.CompletableFuture;

public class AsyncTaskArtifactNotificationsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskArtifactNotificationsClient rawClient;

    public AsyncTaskArtifactNotificationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskArtifactNotificationsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskArtifactNotificationsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves task_artifact notification preferences for the authenticated organization. | () -&gt; (TaskArtifactNotificationPreferences1)
     */
    public CompletableFuture<TaskArtifactNotificationPreferences1> getPreferencesV1() {
        return this.rawClient.getPreferencesV1().thenApply(response -> response.body());
    }

    /**
     * Retrieves task_artifact notification preferences for the authenticated organization. | () -&gt; (TaskArtifactNotificationPreferences1)
     */
    public CompletableFuture<TaskArtifactNotificationPreferences1> getPreferencesV1(RequestOptions requestOptions) {
        return this.rawClient.getPreferencesV1(requestOptions).thenApply(response -> response.body());
    }

    /**
     * Creates or updates task_artifact notification preferences for the authenticated organization. | (TaskArtifactNotificationPreferencesClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> upsertPreferencesV1(TaskArtifactNotificationPreferencesClientCreate1 request) {
        return this.rawClient.upsertPreferencesV1(request).thenApply(response -> response.body());
    }

    /**
     * Creates or updates task_artifact notification preferences for the authenticated organization. | (TaskArtifactNotificationPreferencesClientCreate1) -&gt; (PydanticObjectId)
     */
    public CompletableFuture<String> upsertPreferencesV1(
            TaskArtifactNotificationPreferencesClientCreate1 request, RequestOptions requestOptions) {
        return this.rawClient.upsertPreferencesV1(request, requestOptions).thenApply(response -> response.body());
    }
}
