/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskartifacts.blurhash.AsyncBlurhashClient;
import com.chrt.api.resources.taskartifacts.images.AsyncImagesClient;
import com.chrt.api.resources.taskartifacts.requests.TaskArtifactAddToTaskReq;
import com.chrt.api.resources.taskartifacts.requests.TaskArtifactUpdateCommentsReq;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncTaskArtifactsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTaskArtifactsClient rawClient;

    protected final Supplier<AsyncImagesClient> imagesClient;

    protected final Supplier<AsyncBlurhashClient> blurhashClient;

    public AsyncTaskArtifactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTaskArtifactsClient(clientOptions);
        this.imagesClient = Suppliers.memoize(() -> new AsyncImagesClient(clientOptions));
        this.blurhashClient = Suppliers.memoize(() -> new AsyncBlurhashClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTaskArtifactsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Completes a task_artifact and updates all related task, cargo, task group, and order statuses.
     */
    public CompletableFuture<Boolean> completeV1(String taskArtifactId) {
        return this.rawClient.completeV1(taskArtifactId).thenApply(response -> response.body());
    }

    /**
     * Completes a task_artifact and updates all related task, cargo, task group, and order statuses.
     */
    public CompletableFuture<Boolean> completeV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskArtifactId, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Updates the completor comments on a task_artifact without affecting completion status.
     */
    public CompletableFuture<Boolean> updateCommentsV1(TaskArtifactUpdateCommentsReq request) {
        return this.rawClient.updateCommentsV1(request).thenApply(response -> response.body());
    }

    /**
     * Updates the completor comments on a task_artifact without affecting completion status.
     */
    public CompletableFuture<Boolean> updateCommentsV1(
            TaskArtifactUpdateCommentsReq request, RequestOptions requestOptions) {
        return this.rawClient.updateCommentsV1(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Adds a new task_artifact to an existing task
     */
    public CompletableFuture<String> addToTaskV1(TaskArtifactAddToTaskReq request) {
        return this.rawClient.addToTaskV1(request).thenApply(response -> response.body());
    }

    /**
     * Adds a new task_artifact to an existing task
     */
    public CompletableFuture<String> addToTaskV1(TaskArtifactAddToTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskV1(request, requestOptions).thenApply(response -> response.body());
    }

    public AsyncImagesClient images() {
        return this.imagesClient.get();
    }

    public AsyncBlurhashClient blurhash() {
        return this.blurhashClient.get();
    }
}
