/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.core.Suppliers;
import com.chrt.api.resources.taskartifacts.blurhash.BlurhashClient;
import com.chrt.api.resources.taskartifacts.images.ImagesClient;
import com.chrt.api.resources.taskartifacts.requests.TaskArtifactAddToTaskReq;
import com.chrt.api.resources.taskartifacts.requests.TaskArtifactUpdateCommentsReq;
import java.util.function.Supplier;

public class TaskArtifactsClient {
    protected final ClientOptions clientOptions;

    private final RawTaskArtifactsClient rawClient;

    protected final Supplier<ImagesClient> imagesClient;

    protected final Supplier<BlurhashClient> blurhashClient;

    public TaskArtifactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTaskArtifactsClient(clientOptions);
        this.imagesClient = Suppliers.memoize(() -> new ImagesClient(clientOptions));
        this.blurhashClient = Suppliers.memoize(() -> new BlurhashClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTaskArtifactsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Completes a task_artifact and updates all related task, cargo, task group, and order statuses.
     */
    public boolean completeV1(String taskArtifactId) {
        return this.rawClient.completeV1(taskArtifactId).body();
    }

    /**
     * Completes a task_artifact and updates all related task, cargo, task group, and order statuses.
     */
    public boolean completeV1(String taskArtifactId, RequestOptions requestOptions) {
        return this.rawClient.completeV1(taskArtifactId, requestOptions).body();
    }

    /**
     * Updates the completor comments on a task_artifact without affecting completion status.
     */
    public boolean updateCommentsV1(TaskArtifactUpdateCommentsReq request) {
        return this.rawClient.updateCommentsV1(request).body();
    }

    /**
     * Updates the completor comments on a task_artifact without affecting completion status.
     */
    public boolean updateCommentsV1(TaskArtifactUpdateCommentsReq request, RequestOptions requestOptions) {
        return this.rawClient.updateCommentsV1(request, requestOptions).body();
    }

    /**
     * Adds a new task_artifact to an existing task
     */
    public String addToTaskV1(TaskArtifactAddToTaskReq request) {
        return this.rawClient.addToTaskV1(request).body();
    }

    /**
     * Adds a new task_artifact to an existing task
     */
    public String addToTaskV1(TaskArtifactAddToTaskReq request, RequestOptions requestOptions) {
        return this.rawClient.addToTaskV1(request, requestOptions).body();
    }

    public ImagesClient images() {
        return this.imagesClient.get();
    }

    public BlurhashClient blurhash() {
        return this.blurhashClient.get();
    }
}
