/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.chrt.api.resources.taskartifacts.blurhash;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import java.util.concurrent.CompletableFuture;

public class AsyncBlurhashClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawBlurhashClient rawClient;

    public AsyncBlurhashClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBlurhashClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawBlurhashClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieves the blurhash string for a task_artifact image for fast placeholder loading.
     */
    public CompletableFuture<String> getByMetadataIdV1(String taskArtifactS3ObjectMetadataId) {
        return this.rawClient.getByMetadataIdV1(taskArtifactS3ObjectMetadataId).thenApply(response -> response.body());
    }

    /**
     * Retrieves the blurhash string for a task_artifact image for fast placeholder loading.
     */
    public CompletableFuture<String> getByMetadataIdV1(
            String taskArtifactS3ObjectMetadataId, RequestOptions requestOptions) {
        return this.rawClient
                .getByMetadataIdV1(taskArtifactS3ObjectMetadataId, requestOptions)
                .thenApply(response -> response.body());
    }
}
